/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.wif;

import ch.dissem.bitmessage.BitmessageContext;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.utils.Base58;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WifImporter {
    private static final Logger LOG = LoggerFactory.getLogger(WifImporter.class);
    private final BitmessageContext ctx;
    private final Ini ini = new Ini();
    private final List<BitmessageAddress> identities = new LinkedList<BitmessageAddress>();

    public WifImporter(BitmessageContext ctx, File file) throws IOException {
        this(ctx, new FileInputStream(file), new Pubkey.Feature[0]);
    }

    public WifImporter(BitmessageContext ctx, String data) throws IOException {
        this(ctx, new ByteArrayInputStream(data.getBytes("utf-8")), new Pubkey.Feature[0]);
    }

    public WifImporter(BitmessageContext ctx, InputStream in, Pubkey.Feature ... features) throws IOException {
        this.ctx = ctx;
        Ini ini = new Ini();
        ini.load(in);
        for (Map.Entry entry : ini.entrySet()) {
            if (!((String)entry.getKey()).startsWith("BM-")) continue;
            Profile.Section section = (Profile.Section)entry.getValue();
            BitmessageAddress address = Factory.createIdentityFromPrivateKey((String)((String)entry.getKey()), (byte[])this.getSecret((String)section.get((Object)"privsigningkey")), (byte[])this.getSecret((String)section.get((Object)"privencryptionkey")), (long)((Long)section.get((Object)"noncetrialsperbyte", Long.TYPE)), (long)((Long)section.get((Object)"payloadlengthextrabytes", Long.TYPE)), (int)Pubkey.Feature.bitfield((Pubkey.Feature[])features));
            address.setAlias((String)section.get((Object)"label"));
            this.identities.add(address);
        }
    }

    private byte[] getSecret(String walletImportFormat) throws IOException {
        byte[] bytes = Base58.decode((String)walletImportFormat);
        if (bytes[0] != -128) {
            throw new IOException("Unknown format: 0x80 expected as first byte, but secret " + walletImportFormat + " was " + bytes[0]);
        }
        if (bytes.length != 37) {
            throw new IOException("Unknown format: 37 bytes expected, but secret " + walletImportFormat + " was " + bytes.length + " long");
        }
        byte[] hash = Singleton.security().doubleSha256(bytes, 33);
        for (int i = 0; i < 4; ++i) {
            if (hash[i] == bytes[33 + i]) continue;
            throw new IOException("Hash check failed for secret " + walletImportFormat);
        }
        return Arrays.copyOfRange(bytes, 1, 33);
    }

    public List<BitmessageAddress> getIdentities() {
        return this.identities;
    }

    public WifImporter importAll() {
        for (BitmessageAddress identity : this.identities) {
            this.ctx.addresses().save(identity);
        }
        return this;
    }

    public WifImporter importAll(Collection<BitmessageAddress> identities) {
        for (BitmessageAddress identity : identities) {
            this.ctx.addresses().save(identity);
        }
        return this;
    }

    public WifImporter importIdentity(BitmessageAddress identity) {
        this.ctx.addresses().save(identity);
        return this;
    }
}

