/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.wif;

import ch.dissem.bitmessage.BitmessageContext;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.utils.Base58;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class WifExporter {
    private final BitmessageContext ctx;
    private final Ini ini;

    public WifExporter(BitmessageContext ctx) {
        this.ctx = ctx;
        this.ini = new Ini();
    }

    public WifExporter addAll() {
        for (BitmessageAddress identity : this.ctx.addresses().getIdentities()) {
            this.addIdentity(identity);
        }
        return this;
    }

    public WifExporter addAll(Collection<BitmessageAddress> identities) {
        for (BitmessageAddress identity : identities) {
            this.addIdentity(identity);
        }
        return this;
    }

    public WifExporter addIdentity(BitmessageAddress identity) {
        Profile.Section section = this.ini.add(identity.getAddress());
        section.add((Object)"label", (Object)identity.getAlias());
        section.add("enabled", (Object)true);
        section.add("decoy", (Object)false);
        section.add("noncetrialsperbyte", (Object)identity.getPubkey().getNonceTrialsPerByte());
        section.add("payloadlengthextrabytes", (Object)identity.getPubkey().getExtraBytes());
        section.add((Object)"privsigningkey", (Object)this.exportSecret(identity.getPrivateKey().getPrivateSigningKey()));
        section.add((Object)"privencryptionkey", (Object)this.exportSecret(identity.getPrivateKey().getPrivateEncryptionKey()));
        return this;
    }

    private String exportSecret(byte[] privateKey) {
        if (privateKey.length != 32) {
            throw new IllegalArgumentException("Private key of length 32 expected, but was " + privateKey.length);
        }
        byte[] result = new byte[37];
        result[0] = -128;
        System.arraycopy(privateKey, 0, result, 1, 32);
        byte[] hash = Singleton.security().doubleSha256(result, 33);
        System.arraycopy(hash, 0, result, 33, 4);
        return Base58.encode((byte[])result);
    }

    public void write(File file) throws IOException {
        file.createNewFile();
        try (FileOutputStream out = new FileOutputStream(file);){
            this.write(out);
        }
    }

    public void write(OutputStream out) throws IOException {
        this.ini.store(out);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.ini.store((Writer)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }
}

