/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.entity.valueobject.Label;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.ports.AbstractMessageRepository;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcHelper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMessageRepository
extends AbstractMessageRepository
implements MessageRepository {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcMessageRepository.class);
    private final JdbcConfig config;

    public JdbcMessageRepository(JdbcConfig config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Label> findLabels(String where) {
        try (Connection connection = this.config.getConnection();){
            List<Label> list = this.findLabels(connection, where);
            return list;
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new ArrayList<Label>();
        }
    }

    private Label getLabel(ResultSet rs) throws SQLException {
        String typeName = rs.getString("type");
        Label.Type type = null;
        if (typeName != null) {
            type = Label.Type.valueOf((String)typeName);
        }
        Label label = new Label(rs.getString("label"), type, rs.getInt("color"));
        label.setId((Object)rs.getLong("id"));
        return label;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countUnread(Label label) {
        String where = label == null ? "" : "id IN (SELECT message_id FROM Message_Label WHERE label_id=" + label.getId() + ") AND ";
        where = where + "id IN (SELECT message_id FROM Message_Label WHERE label_id IN (SELECT id FROM Label WHERE type = '" + Label.Type.UNREAD.name() + "'))";
        try (Connection connection = this.config.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT count(*) FROM Message WHERE " + where);){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    protected List<Plaintext> find(String where) {
        LinkedList<Plaintext> result = new LinkedList<Plaintext>();
        try (Connection connection = this.config.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT id, iv, type, sender, recipient, data, ack_data, sent, received, initial_hash, status, ttl, retries, next_try FROM Message WHERE " + where);){
            while (rs.next()) {
                byte[] iv = rs.getBytes("iv");
                InputStream data = rs.getBinaryStream("data");
                Plaintext.Type type = Plaintext.Type.valueOf((String)rs.getString("type"));
                Plaintext.Builder builder = Plaintext.readWithoutSignature((Plaintext.Type)type, (InputStream)data);
                long id = rs.getLong("id");
                builder.id((Object)id);
                builder.IV(new InventoryVector(iv));
                builder.from(this.ctx.getAddressRepository().getAddress(rs.getString("sender")));
                builder.to(this.ctx.getAddressRepository().getAddress(rs.getString("recipient")));
                builder.ackData(rs.getBytes("ack_data"));
                builder.sent(rs.getLong("sent"));
                builder.received(rs.getLong("received"));
                builder.status(Plaintext.Status.valueOf((String)rs.getString("status")));
                builder.ttl(rs.getLong("ttl"));
                builder.retries(rs.getInt("retries"));
                builder.nextTry(Long.valueOf(rs.getLong("next_try")));
                builder.labels(this.findLabels(connection, "id IN (SELECT label_id FROM Message_Label WHERE message_id=" + id + ") ORDER BY ord"));
                Plaintext message = builder.build();
                message.setInitialHash(rs.getBytes("initial_hash"));
                result.add(message);
            }
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private List<Label> findLabels(Connection connection, String where) {
        ArrayList<Label> result = new ArrayList<Label>();
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT id, label, type, color FROM Label WHERE " + where);){
            while (rs.next()) {
                result.add(this.getLabel(rs));
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void save(Plaintext message) {
        this.safeSenderIfNecessary(message);
        try (Connection connection = this.config.getConnection();){
            try {
                connection.setAutoCommit(false);
                this.save(connection, message);
                this.updateLabels(connection, message);
                connection.commit();
            }
            catch (IOException | SQLException e) {
                connection.rollback();
                throw e;
            }
        }
        catch (IOException | SQLException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private void save(Connection connection, Plaintext message) throws IOException, SQLException {
        if (message.getId() == null) {
            this.insert(connection, message);
        } else {
            this.update(connection, message);
        }
    }

    private void updateLabels(Connection connection, Plaintext message) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate("DELETE FROM Message_Label WHERE message_id=" + message.getId());
        }
        var4_4 = null;
        try (PreparedStatement ps = connection.prepareStatement("INSERT INTO Message_Label VALUES (" + message.getId() + ", ?)");){
            for (Label label : message.getLabels()) {
                ps.setLong(1, (Long)label.getId());
                ps.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private void insert(Connection connection, Plaintext message) throws SQLException, IOException {
        try (PreparedStatement ps = connection.prepareStatement("INSERT INTO Message (iv, type, sender, recipient, data, ack_data, sent, received, status, initial_hash, ttl, retries, next_try) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);){
            ps.setBytes(1, message.getInventoryVector() == null ? null : message.getInventoryVector().getHash());
            ps.setString(2, message.getType().name());
            ps.setString(3, message.getFrom().getAddress());
            ps.setString(4, message.getTo() == null ? null : message.getTo().getAddress());
            JdbcHelper.writeBlob(ps, 5, (Streamable)message);
            ps.setBytes(6, message.getAckData());
            ps.setLong(7, message.getSent());
            ps.setLong(8, message.getReceived());
            ps.setString(9, message.getStatus() == null ? null : message.getStatus().name());
            ps.setBytes(10, message.getInitialHash());
            ps.setLong(11, message.getTTL());
            ps.setInt(12, message.getRetries());
            ps.setObject(13, message.getNextTry());
            ps.executeUpdate();
            try (ResultSet rs = ps.getGeneratedKeys();){
                rs.next();
                message.setId(rs.getLong(1));
            }
        }
    }

    private void update(Connection connection, Plaintext message) throws SQLException, IOException {
        try (PreparedStatement ps = connection.prepareStatement("UPDATE Message SET iv=?, type=?, sender=?, recipient=?, data=?, ack_data=?, sent=?, received=?, status=?, initial_hash=?, ttl=?, retries=?, next_try=? WHERE id=?");){
            ps.setBytes(1, message.getInventoryVector() == null ? null : message.getInventoryVector().getHash());
            ps.setString(2, message.getType().name());
            ps.setString(3, message.getFrom().getAddress());
            ps.setString(4, message.getTo() == null ? null : message.getTo().getAddress());
            JdbcHelper.writeBlob(ps, 5, (Streamable)message);
            ps.setBytes(6, message.getAckData());
            ps.setLong(7, message.getSent());
            ps.setLong(8, message.getReceived());
            ps.setString(9, message.getStatus() == null ? null : message.getStatus().name());
            ps.setBytes(10, message.getInitialHash());
            ps.setLong(11, message.getTTL());
            ps.setInt(12, message.getRetries());
            ps.setObject(13, message.getNextTry());
            ps.setLong(14, (Long)message.getId());
            ps.executeUpdate();
        }
    }

    public void remove(Plaintext message) {
        try (Connection connection = this.config.getConnection();){
            connection.setAutoCommit(false);
            try (Statement stmt = connection.createStatement();){
                stmt.executeUpdate("DELETE FROM Message_Label WHERE message_id = " + message.getId());
                stmt.executeUpdate("DELETE FROM Message WHERE id = " + message.getId());
                connection.commit();
            }
            catch (SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    LOG.debug(e1.getMessage(), (Throwable)e);
                }
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

