/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.ports.Inventory;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcHelper;
import ch.dissem.bitmessage.utils.UnixTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcInventory
extends JdbcHelper
implements Inventory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcInventory.class);
    private final Map<Long, Map<InventoryVector, Long>> cache = new ConcurrentHashMap<Long, Map<InventoryVector, Long>>();

    public JdbcInventory(JdbcConfig config) {
        super(config);
    }

    public List<InventoryVector> getInventory(long ... streams) {
        LinkedList<InventoryVector> result = new LinkedList<InventoryVector>();
        for (long stream : streams) {
            this.getCache(stream).entrySet().stream().filter(e -> (Long)e.getValue() > UnixTime.now()).forEach(e -> result.add((InventoryVector)e.getKey()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<InventoryVector, Long> getCache(long stream) {
        Map<InventoryVector, Long> result = this.cache.get(stream);
        if (result == null) {
            Map<Long, Map<InventoryVector, Long>> map = this.cache;
            synchronized (map) {
                if (this.cache.get(stream) == null) {
                    result = new ConcurrentHashMap<InventoryVector, Long>();
                    this.cache.put(stream, result);
                    try (Connection connection = this.config.getConnection();
                         Statement stmt = connection.createStatement();
                         ResultSet rs = stmt.executeQuery("SELECT hash, expires FROM Inventory WHERE expires > " + UnixTime.now((long)-300L) + " AND stream = " + stream);){
                        while (rs.next()) {
                            result.put(new InventoryVector(rs.getBytes("hash")), rs.getLong("expires"));
                        }
                    }
                    catch (SQLException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public List<InventoryVector> getMissing(List<InventoryVector> offer, long ... streams) {
        for (long stream : streams) {
            offer.removeAll(this.getCache(stream).keySet());
        }
        return offer;
    }

    /*
     * Exception decompiling
     */
    public ObjectMessage getObject(InventoryVector vector) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<ObjectMessage> getObjects(long stream, long version, ObjectType ... types) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void storeObject(ObjectMessage object) {
        if (this.getCache(object.getStream()).containsKey(object.getInventoryVector())) {
            return;
        }
        try (Connection connection = this.config.getConnection();
             PreparedStatement ps = connection.prepareStatement("INSERT INTO Inventory (hash, stream, expires, data, type, version) VALUES (?, ?, ?, ?, ?, ?)");){
            InventoryVector iv = object.getInventoryVector();
            LOG.trace("Storing object " + iv);
            ps.setBytes(1, iv.getHash());
            ps.setLong(2, object.getStream());
            ps.setLong(3, object.getExpiresTime());
            JdbcInventory.writeBlob(ps, 4, (Streamable)object);
            ps.setLong(5, object.getType());
            ps.setLong(6, object.getVersion());
            ps.executeUpdate();
            this.getCache(object.getStream()).put(iv, object.getExpiresTime());
        }
        catch (SQLException e) {
            LOG.debug("Error storing object of type " + object.getPayload().getClass().getSimpleName(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean contains(ObjectMessage object) {
        return this.getCache(object.getStream()).entrySet().stream().anyMatch(x -> ((InventoryVector)x.getKey()).equals((Object)object.getInventoryVector()));
    }

    public void cleanup() {
        try (Connection connection = this.config.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.executeUpdate("DELETE FROM Inventory WHERE expires < " + UnixTime.now((long)-300L));
        }
        catch (SQLException e2) {
            LOG.debug(e2.getMessage(), (Throwable)e2);
        }
        for (Map<InventoryVector, Long> c : this.cache.values()) {
            c.entrySet().removeIf(e -> (Long)e.getValue() < UnixTime.now((long)-300L));
        }
    }
}

