/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.payload.V3Pubkey;
import ch.dissem.bitmessage.entity.payload.V4Pubkey;
import ch.dissem.bitmessage.entity.valueobject.PrivateKey;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.ports.AddressRepository;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcAddressRepository
extends JdbcHelper
implements AddressRepository {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcAddressRepository.class);

    public JdbcAddressRepository(JdbcConfig config) {
        super(config);
    }

    public BitmessageAddress findContact(byte[] ripeOrTag) {
        for (BitmessageAddress address : this.find("public_key is null")) {
            if (!(address.getVersion() > 3L ? Arrays.equals(ripeOrTag, address.getTag()) : Arrays.equals(ripeOrTag, address.getRipe()))) continue;
            return address;
        }
        return null;
    }

    public BitmessageAddress findIdentity(byte[] ripeOrTag) {
        for (BitmessageAddress address : this.find("private_key is not null")) {
            if (!(address.getVersion() > 3L ? Arrays.equals(ripeOrTag, address.getTag()) : Arrays.equals(ripeOrTag, address.getRipe()))) continue;
            return address;
        }
        return null;
    }

    public List<BitmessageAddress> getIdentities() {
        return this.find("private_key IS NOT NULL");
    }

    public List<BitmessageAddress> getChans() {
        return this.find("chan = '1'");
    }

    public List<BitmessageAddress> getSubscriptions() {
        return this.find("subscribed = '1'");
    }

    public List<BitmessageAddress> getSubscriptions(long broadcastVersion) {
        if (broadcastVersion > 4L) {
            return this.find("subscribed = '1' AND version > 3");
        }
        return this.find("subscribed = '1' AND version <= 3");
    }

    public List<BitmessageAddress> getContacts() {
        return this.find("private_key IS NULL OR chan = '1'");
    }

    private List<BitmessageAddress> find(String where) {
        LinkedList<BitmessageAddress> result = new LinkedList<BitmessageAddress>();
        try (Connection connection = this.config.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT address, alias, public_key, private_key, subscribed, chan FROM Address WHERE " + where);){
            while (rs.next()) {
                BitmessageAddress address;
                InputStream privateKeyStream = rs.getBinaryStream("private_key");
                if (privateKeyStream == null) {
                    address = new BitmessageAddress(rs.getString("address"));
                    Blob publicKeyBlob = rs.getBlob("public_key");
                    if (publicKeyBlob != null) {
                        Pubkey pubkey = Factory.readPubkey((long)address.getVersion(), (long)address.getStream(), (InputStream)publicKeyBlob.getBinaryStream(), (int)((int)publicKeyBlob.length()), (boolean)false);
                        if (address.getVersion() == 4L && pubkey instanceof V3Pubkey) {
                            pubkey = new V4Pubkey((V3Pubkey)pubkey);
                        }
                        address.setPubkey(pubkey);
                    }
                } else {
                    PrivateKey privateKey = PrivateKey.read((InputStream)privateKeyStream);
                    address = new BitmessageAddress(privateKey);
                }
                address.setAlias(rs.getString("alias"));
                address.setSubscribed(rs.getBoolean("subscribed"));
                address.setChan(rs.getBoolean("chan"));
                result.add(address);
            }
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exists(BitmessageAddress address) {
        try (Connection connection = this.config.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM Address WHERE address='" + address.getAddress() + "'");){
            if (!rs.next()) return false;
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void save(BitmessageAddress address) {
        try {
            if (this.exists(address)) {
                this.update(address);
            } else {
                this.insert(address);
            }
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void update(BitmessageAddress address) throws IOException, SQLException {
        StringBuilder statement = new StringBuilder("UPDATE Address SET alias=?");
        if (address.getPubkey() != null) {
            statement.append(", public_key=?");
        }
        if (address.getPrivateKey() != null) {
            statement.append(", private_key=?");
        }
        statement.append(", subscribed=?, chan=? WHERE address=?");
        try (Connection connection = this.config.getConnection();
             PreparedStatement ps = connection.prepareStatement(statement.toString());){
            int i = 0;
            ps.setString(++i, address.getAlias());
            if (address.getPubkey() != null) {
                this.writePubkey(ps, ++i, address.getPubkey());
            }
            if (address.getPrivateKey() != null) {
                JdbcAddressRepository.writeBlob(ps, ++i, (Streamable)address.getPrivateKey());
            }
            ps.setBoolean(++i, address.isSubscribed());
            ps.setBoolean(++i, address.isChan());
            ps.setString(++i, address.getAddress());
            ps.executeUpdate();
        }
    }

    private void insert(BitmessageAddress address) throws IOException, SQLException {
        try (Connection connection = this.config.getConnection();
             PreparedStatement ps = connection.prepareStatement("INSERT INTO Address (address, version, alias, public_key, private_key, subscribed, chan) VALUES (?, ?, ?, ?, ?, ?, ?)");){
            ps.setString(1, address.getAddress());
            ps.setLong(2, address.getVersion());
            ps.setString(3, address.getAlias());
            this.writePubkey(ps, 4, address.getPubkey());
            JdbcAddressRepository.writeBlob(ps, 5, (Streamable)address.getPrivateKey());
            ps.setBoolean(6, address.isSubscribed());
            ps.setBoolean(7, address.isChan());
            ps.executeUpdate();
        }
    }

    protected void writePubkey(PreparedStatement ps, int parameterIndex, Pubkey data) throws SQLException, IOException {
        if (data != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            data.writeUnencrypted((OutputStream)out);
            ps.setBytes(parameterIndex, out.toByteArray());
        } else {
            ps.setBytes(parameterIndex, null);
        }
    }

    public void remove(BitmessageAddress address) {
        try (Connection connection = this.config.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.executeUpdate("DELETE FROM Address WHERE address = '" + address.getAddress() + "'");
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public BitmessageAddress getAddress(String address) {
        List<BitmessageAddress> result = this.find("address = '" + address + "'");
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }
}

