/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.ports.NodeRegistry;
import ch.dissem.bitmessage.ports.NodeRegistryHelper;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcHelper;
import ch.dissem.bitmessage.utils.Collections;
import ch.dissem.bitmessage.utils.SqlStrings;
import ch.dissem.bitmessage.utils.UnixTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcNodeRegistry
extends JdbcHelper
implements NodeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcNodeRegistry.class);
    private Map<Long, Set<NetworkAddress>> stableNodes;

    public JdbcNodeRegistry(JdbcConfig config) {
        super(config);
        this.cleanUp();
    }

    private void cleanUp() {
        try (Connection connection = this.config.getConnection();
             PreparedStatement ps = connection.prepareStatement("DELETE FROM Node WHERE time<?");){
            ps.setLong(1, UnixTime.now((long)-2419200L));
            ps.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private NetworkAddress loadExisting(NetworkAddress node) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkAddress> getKnownAddresses(int limit, long ... streams) {
        LinkedList<NetworkAddress> result = new LinkedList<NetworkAddress>();
        String query = "SELECT stream, address, port, services, time FROM Node WHERE stream IN (" + SqlStrings.join((long[])streams) + ")" + " ORDER BY TIME DESC" + " LIMIT " + limit;
        try (Connection connection = this.config.getConnection();
             Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                result.add(new NetworkAddress.Builder().stream(rs.getLong("stream")).ipv6(rs.getBytes("address")).port(rs.getInt("port")).services(rs.getLong("services")).time(rs.getLong("time")).build());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new ApplicationException((Throwable)e);
        }
        if (result.isEmpty()) {
            JdbcNodeRegistry jdbcNodeRegistry = this;
            synchronized (jdbcNodeRegistry) {
                if (this.stableNodes == null) {
                    this.stableNodes = NodeRegistryHelper.loadStableNodes();
                }
            }
            for (Object stream : (JdbcNodeRegistry)streams) {
                Set<NetworkAddress> nodes = this.stableNodes.get((long)stream);
                if (nodes == null || nodes.isEmpty()) continue;
                result.add((NetworkAddress)Collections.selectRandom(nodes));
            }
        }
        return result;
    }

    public void offerAddresses(List<NetworkAddress> nodes) {
        this.cleanUp();
        nodes.stream().filter(node -> node.getTime() < UnixTime.now((long)120L) && node.getTime() > UnixTime.now((long)-2419200L)).forEach(node -> {
            JdbcNodeRegistry jdbcNodeRegistry = this;
            synchronized (jdbcNodeRegistry) {
                NetworkAddress existing = this.loadExisting((NetworkAddress)node);
                if (existing == null) {
                    this.insert((NetworkAddress)node);
                } else if (node.getTime() > existing.getTime()) {
                    this.update((NetworkAddress)node);
                }
            }
        });
    }

    private void insert(NetworkAddress node) {
        try (Connection connection = this.config.getConnection();
             PreparedStatement ps = connection.prepareStatement("INSERT INTO Node (stream, address, port, services, time) VALUES (?, ?, ?, ?, ?)");){
            ps.setLong(1, node.getStream());
            ps.setBytes(2, node.getIPv6());
            ps.setInt(3, node.getPort());
            ps.setLong(4, node.getServices());
            ps.setLong(5, node.getTime());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void update(NetworkAddress node) {
        try (Connection connection = this.config.getConnection();
             PreparedStatement ps = connection.prepareStatement("UPDATE Node SET services=?, time=? WHERE stream=? AND address=? AND port=?");){
            ps.setLong(1, node.getServices());
            ps.setLong(2, node.getTime());
            ps.setLong(3, node.getStream());
            ps.setBytes(4, node.getIPv6());
            ps.setInt(5, node.getPort());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

