/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.ports.NodeRegistry;
import ch.dissem.bitmessage.utils.UnixTime;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryNodeRegistry
implements NodeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryNodeRegistry.class);
    private final Map<Long, Set<NetworkAddress>> stableNodes = new HashMap<Long, Set<NetworkAddress>>();
    private final Map<Long, Set<NetworkAddress>> knownNodes = new ConcurrentHashMap<Long, Set<NetworkAddress>>();

    public MemoryNodeRegistry() {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("nodes.txt");){
            Scanner scanner = new Scanner(in);
            long stream = 0L;
            HashSet<NetworkAddress> streamSet = null;
            while (scanner.hasNext()) {
                try {
                    String line = scanner.nextLine().trim();
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    if (line.startsWith("[stream")) {
                        stream = Long.parseLong(line.substring(8, line.lastIndexOf(93)));
                        streamSet = new HashSet<NetworkAddress>();
                        this.stableNodes.put(stream, streamSet);
                        continue;
                    }
                    if (streamSet == null) continue;
                    int portIndex = line.lastIndexOf(58);
                    InetAddress inetAddress = InetAddress.getByName(line.substring(0, portIndex));
                    int port = Integer.valueOf(line.substring(portIndex + 1));
                    streamSet.add(new NetworkAddress.Builder().ip(inetAddress).port(port).stream(stream).build());
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<NetworkAddress> getKnownAddresses(int limit, long ... streams) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (long stream : streams) {
            Set<NetworkAddress> known = this.knownNodes.get(stream);
            if (known != null && !known.isEmpty()) {
                for (NetworkAddress node : known) {
                    if (node.getTime() > UnixTime.now((long)-10800L)) {
                        result.add(node);
                        continue;
                    }
                    known.remove(node);
                }
                continue;
            }
            if (!this.stableNodes.containsKey(stream)) continue;
            result.add(ch.dissem.bitmessage.utils.Collections.selectRandom((Collection)this.stableNodes.get(stream)));
        }
        return ch.dissem.bitmessage.utils.Collections.selectRandom((int)limit, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerAddresses(List<NetworkAddress> addresses) {
        for (NetworkAddress node : addresses) {
            if (node.getTime() > UnixTime.now()) continue;
            if (!this.knownNodes.containsKey(node.getStream())) {
                Map<Long, Set<NetworkAddress>> map = this.knownNodes;
                synchronized (map) {
                    if (!this.knownNodes.containsKey(node.getStream())) {
                        this.knownNodes.put(node.getStream(), Collections.newSetFromMap(new ConcurrentHashMap()));
                    }
                }
            }
            if (node.getTime() > UnixTime.now()) continue;
            this.knownNodes.get(node.getStream()).add(node);
        }
    }
}

