/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.entity.valueobject.Label;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcHelper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcMessageRepository
extends JdbcHelper
implements MessageRepository,
InternalContext.ContextHolder {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcMessageRepository.class);
    private InternalContext ctx;

    public JdbcMessageRepository(JdbcConfig config) {
        super(config);
    }

    public List<Label> getLabels() {
        LinkedList<Label> result = new LinkedList<Label>();
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT id, label, type, color FROM Label ORDER BY ord");
            while (rs.next()) {
                result.add(this.getLabel(rs));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private Label getLabel(ResultSet rs) throws SQLException {
        String typeName = rs.getString("type");
        Label.Type type = null;
        if (typeName != null) {
            type = Label.Type.valueOf((String)typeName);
        }
        Label label = new Label(rs.getString("label"), type, rs.getInt("color"));
        label.setId((Object)rs.getLong("id"));
        return label;
    }

    public List<Label> getLabels(Label.Type ... types) {
        LinkedList<Label> result = new LinkedList<Label>();
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT id, label, type, color FROM Label WHERE type IN (" + JdbcMessageRepository.join((Enum[])types) + ") ORDER BY ord");
            while (rs.next()) {
                result.add(this.getLabel(rs));
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<Plaintext> findMessages(Label label) {
        return this.find("id IN (SELECT message_id FROM Message_Label WHERE label_id=" + label.getId() + ")");
    }

    public List<Plaintext> findMessages(Plaintext.Status status, BitmessageAddress recipient) {
        return this.find("status='" + status.name() + "' AND recipient='" + recipient.getAddress() + "'");
    }

    public List<Plaintext> findMessages(Plaintext.Status status) {
        return this.find("status='" + status.name() + "'");
    }

    private List<Plaintext> find(String where) {
        LinkedList<Plaintext> result = new LinkedList<Plaintext>();
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT id, iv, type, sender, recipient, data, sent, received, status FROM Message WHERE " + where);
            while (rs.next()) {
                byte[] iv = rs.getBytes("iv");
                Blob data = rs.getBlob("data");
                Plaintext.Type type = Plaintext.Type.valueOf((String)rs.getString("type"));
                Plaintext.Builder builder = Plaintext.readWithoutSignature((Plaintext.Type)type, (InputStream)data.getBinaryStream());
                long id = rs.getLong("id");
                builder.id((Object)id);
                builder.IV(new InventoryVector(iv));
                builder.from(this.ctx.getAddressRepo().getAddress(rs.getString("sender")));
                builder.to(this.ctx.getAddressRepo().getAddress(rs.getString("recipient")));
                builder.sent(rs.getLong("sent"));
                builder.received(rs.getLong("received"));
                builder.status(Plaintext.Status.valueOf((String)rs.getString("status")));
                builder.labels(this.findLabels(connection, id));
                result.add(builder.build());
            }
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Collection<Label> findLabels(Connection connection, long messageId) {
        ArrayList<Label> result = new ArrayList<Label>();
        try {
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT id, label, type, color FROM Label WHERE id IN (SELECT label_id FROM Message_Label WHERE message_id=" + messageId + ")");
            while (rs.next()) {
                result.add(this.getLabel(rs));
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public void save(Plaintext message) {
        BitmessageAddress savedAddress;
        if (message.getId() == null && ((savedAddress = this.ctx.getAddressRepo().getAddress(message.getFrom().getAddress())) == null || savedAddress.getPrivateKey() == null)) {
            if (savedAddress != null && savedAddress.getAlias() != null) {
                message.getFrom().setAlias(savedAddress.getAlias());
            }
            this.ctx.getAddressRepo().save(message.getFrom());
        }
        try (Connection connection = this.config.getConnection();){
            try {
                connection.setAutoCommit(false);
                if (message.getId() == null) {
                    this.insert(connection, message);
                } else {
                    this.update(connection, message);
                }
                Statement stmt = connection.createStatement();
                stmt.executeUpdate("DELETE FROM Message_Label WHERE message_id=" + message.getId());
                PreparedStatement ps = connection.prepareStatement("INSERT INTO Message_Label VALUES (" + message.getId() + ", ?)");
                for (Label label : message.getLabels()) {
                    ps.setLong(1, (Long)label.getId());
                    ps.executeUpdate();
                }
                connection.commit();
            }
            catch (IOException | SQLException e) {
                try {
                    connection.rollback();
                }
                catch (SQLException e1) {
                    LOG.debug(e1.getMessage(), (Throwable)e);
                }
                throw new RuntimeException(e);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void insert(Connection connection, Plaintext message) throws SQLException, IOException {
        PreparedStatement ps = connection.prepareStatement("INSERT INTO Message (iv, type, sender, recipient, data, sent, received, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", 1);
        ps.setBytes(1, message.getInventoryVector() != null ? message.getInventoryVector().getHash() : null);
        ps.setString(2, message.getType().name());
        ps.setString(3, message.getFrom().getAddress());
        ps.setString(4, message.getTo() != null ? message.getTo().getAddress() : null);
        this.writeBlob(ps, 5, (Streamable)message);
        ps.setLong(6, message.getSent());
        ps.setLong(7, message.getReceived());
        ps.setString(8, message.getStatus() != null ? message.getStatus().name() : null);
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        message.setId(rs.getLong(1));
    }

    private void update(Connection connection, Plaintext message) throws SQLException, IOException {
        PreparedStatement ps = connection.prepareStatement("UPDATE Message SET iv=?, sent=?, received=?, status=? WHERE id=?");
        ps.setBytes(1, message.getInventoryVector() != null ? message.getInventoryVector().getHash() : null);
        ps.setLong(2, message.getSent());
        ps.setLong(3, message.getReceived());
        ps.setString(4, message.getStatus() != null ? message.getStatus().name() : null);
        ps.setLong(5, (Long)message.getId());
        ps.executeUpdate();
    }

    public void remove(Plaintext message) {
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            stmt.executeUpdate("DELETE FROM Message WHERE id = " + message.getId());
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setContext(InternalContext context) {
        this.ctx = context;
    }
}

