/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.ports.Inventory;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcHelper;
import ch.dissem.bitmessage.utils.UnixTime;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcInventory
extends JdbcHelper
implements Inventory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcInventory.class);

    public JdbcInventory(JdbcConfig config) {
        super(config);
    }

    public List<InventoryVector> getInventory(long ... streams) {
        LinkedList<InventoryVector> result = new LinkedList<InventoryVector>();
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT hash FROM Inventory WHERE expires > " + UnixTime.now() + " AND stream IN (" + JdbcInventory.join(streams) + ")");
            while (rs.next()) {
                result.add(new InventoryVector(rs.getBytes("hash")));
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private List<InventoryVector> getFullInventory(long ... streams) {
        LinkedList<InventoryVector> result = new LinkedList<InventoryVector>();
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT hash FROM Inventory WHERE stream IN (" + JdbcInventory.join(streams) + ")");
            while (rs.next()) {
                result.add(new InventoryVector(rs.getBytes("hash")));
            }
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List<InventoryVector> getMissing(List<InventoryVector> offer, long ... streams) {
        offer.removeAll(this.getFullInventory(streams));
        return offer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectMessage getObject(InventoryVector vector) {
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT data, version FROM Inventory WHERE hash = X'" + vector + "'");
            if (rs.next()) {
                Blob data = rs.getBlob("data");
                ObjectMessage objectMessage = Factory.getObjectMessage((int)rs.getInt("version"), (InputStream)data.getBinaryStream(), (int)((int)data.length()));
                return objectMessage;
            }
            LOG.info("Object requested that we don't have. IV: " + vector);
            ObjectMessage objectMessage = null;
            return objectMessage;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ObjectMessage> getObjects(long stream, long version, ObjectType ... types) {
        try (Connection connection = this.config.getConnection();){
            StringBuilder query = new StringBuilder("SELECT data, version FROM Inventory WHERE 1=1");
            if (stream > 0L) {
                query.append(" AND stream = ").append(stream);
            }
            if (version > 0L) {
                query.append(" AND version = ").append(version);
            }
            if (types.length > 0) {
                query.append(" AND type IN (").append((CharSequence)JdbcInventory.join(types)).append(")");
            }
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery(query.toString());
            LinkedList<ObjectMessage> result = new LinkedList<ObjectMessage>();
            while (rs.next()) {
                Blob data = rs.getBlob("data");
                result.add(Factory.getObjectMessage((int)rs.getInt("version"), (InputStream)data.getBinaryStream(), (int)((int)data.length())));
            }
            LinkedList<ObjectMessage> linkedList = result;
            return linkedList;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void storeObject(ObjectMessage object) {
        try (Connection connection = this.config.getConnection();){
            PreparedStatement ps = connection.prepareStatement("INSERT INTO Inventory (hash, stream, expires, data, type, version) VALUES (?, ?, ?, ?, ?, ?)");
            InventoryVector iv = object.getInventoryVector();
            LOG.trace("Storing object " + iv);
            ps.setBytes(1, iv.getHash());
            ps.setLong(2, object.getStream());
            ps.setLong(3, object.getExpiresTime());
            this.writeBlob(ps, 4, (Streamable)object);
            ps.setLong(5, object.getType());
            ps.setLong(6, object.getVersion());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            LOG.debug("Error storing object of type " + object.getPayload().getClass().getSimpleName(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup() {
        try (Connection connection = this.config.getConnection();){
            connection.createStatement().executeUpdate("DELETE FROM Inventory WHERE expires < " + (UnixTime.now() - 300L));
        }
        catch (SQLException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }
}

