/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.utils.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class JdbcHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcHelper.class);
    protected final JdbcConfig config;

    protected JdbcHelper(JdbcConfig config) {
        this.config = config;
    }

    public static StringBuilder join(long ... objects) {
        StringBuilder streamList = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0) {
                streamList.append(", ");
            }
            streamList.append(objects[i]);
        }
        return streamList;
    }

    public static StringBuilder join(byte[] ... objects) {
        StringBuilder streamList = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0) {
                streamList.append(", ");
            }
            streamList.append((CharSequence)Strings.hex((byte[])objects[i]));
        }
        return streamList;
    }

    public static StringBuilder join(ObjectType ... types) {
        StringBuilder streamList = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                streamList.append(", ");
            }
            streamList.append(types[i].getNumber());
        }
        return streamList;
    }

    public static StringBuilder join(Enum ... types) {
        StringBuilder streamList = new StringBuilder();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                streamList.append(", ");
            }
            streamList.append('\'').append(types[i].name()).append('\'');
        }
        return streamList;
    }

    protected void writeBlob(PreparedStatement ps, int parameterIndex, Streamable data) throws SQLException, IOException {
        if (data != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            data.write((OutputStream)os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            ps.setBlob(parameterIndex, is);
        } else {
            ps.setBlob(parameterIndex, (Blob)null);
        }
    }
}

