/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.repository;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.payload.V3Pubkey;
import ch.dissem.bitmessage.entity.payload.V4Pubkey;
import ch.dissem.bitmessage.entity.valueobject.PrivateKey;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.ports.AddressRepository;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcAddressRepository
extends JdbcHelper
implements AddressRepository {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcAddressRepository.class);

    public JdbcAddressRepository(JdbcConfig config) {
        super(config);
    }

    public BitmessageAddress findContact(byte[] ripeOrTag) {
        for (BitmessageAddress address : this.find("public_key is null")) {
            if (!(address.getVersion() > 3L ? Arrays.equals(ripeOrTag, address.getTag()) : Arrays.equals(ripeOrTag, address.getRipe()))) continue;
            return address;
        }
        return null;
    }

    public BitmessageAddress findIdentity(byte[] ripeOrTag) {
        for (BitmessageAddress address : this.find("private_key is not null")) {
            if (!(address.getVersion() > 3L ? Arrays.equals(ripeOrTag, address.getTag()) : Arrays.equals(ripeOrTag, address.getRipe()))) continue;
            return address;
        }
        return null;
    }

    public List<BitmessageAddress> getIdentities() {
        return this.find("private_key IS NOT NULL");
    }

    public List<BitmessageAddress> getSubscriptions() {
        return this.find("subscribed = '1'");
    }

    public List<BitmessageAddress> getSubscriptions(long broadcastVersion) {
        if (broadcastVersion > 4L) {
            return this.find("subscribed = '1' AND version > 3");
        }
        return this.find("subscribed = '1' AND version <= 3");
    }

    public List<BitmessageAddress> getContacts() {
        return this.find("private_key IS NULL");
    }

    private List<BitmessageAddress> find(String where) {
        LinkedList<BitmessageAddress> result = new LinkedList<BitmessageAddress>();
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT address, alias, public_key, private_key, subscribed FROM Address WHERE " + where);
            while (rs.next()) {
                BitmessageAddress address;
                Blob privateKeyBlob = rs.getBlob("private_key");
                if (privateKeyBlob != null) {
                    PrivateKey privateKey = PrivateKey.read((InputStream)privateKeyBlob.getBinaryStream());
                    address = new BitmessageAddress(privateKey);
                } else {
                    address = new BitmessageAddress(rs.getString("address"));
                    Blob publicKeyBlob = rs.getBlob("public_key");
                    if (publicKeyBlob != null) {
                        Pubkey pubkey = Factory.readPubkey((long)address.getVersion(), (long)address.getStream(), (InputStream)publicKeyBlob.getBinaryStream(), (int)((int)publicKeyBlob.length()), (boolean)false);
                        if (address.getVersion() == 4L && pubkey instanceof V3Pubkey) {
                            pubkey = new V4Pubkey((V3Pubkey)pubkey);
                        }
                        address.setPubkey(pubkey);
                    }
                }
                address.setAlias(rs.getString("alias"));
                address.setSubscribed(rs.getBoolean("subscribed"));
                result.add(address);
            }
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean exists(BitmessageAddress address) {
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM Address WHERE address='" + address.getAddress() + "'");
            rs.next();
            boolean bl = rs.getInt(1) > 0;
            return bl;
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void save(BitmessageAddress address) {
        try {
            if (this.exists(address)) {
                this.update(address);
            } else {
                this.insert(address);
            }
        }
        catch (IOException | SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void update(BitmessageAddress address) throws IOException, SQLException {
        try (Connection connection = this.config.getConnection();){
            PreparedStatement ps = connection.prepareStatement("UPDATE Address SET alias=?, public_key=?, private_key=?, subscribed=? WHERE address=?");
            ps.setString(1, address.getAlias());
            this.writePubkey(ps, 2, address.getPubkey());
            this.writeBlob(ps, 3, (Streamable)address.getPrivateKey());
            ps.setBoolean(4, address.isSubscribed());
            ps.setString(5, address.getAddress());
            ps.executeUpdate();
        }
    }

    private void insert(BitmessageAddress address) throws IOException, SQLException {
        try (Connection connection = this.config.getConnection();){
            PreparedStatement ps = connection.prepareStatement("INSERT INTO Address (address, version, alias, public_key, private_key, subscribed) VALUES (?, ?, ?, ?, ?, ?)");
            ps.setString(1, address.getAddress());
            ps.setLong(2, address.getVersion());
            ps.setString(3, address.getAlias());
            this.writePubkey(ps, 4, address.getPubkey());
            this.writeBlob(ps, 5, (Streamable)address.getPrivateKey());
            ps.setBoolean(6, address.isSubscribed());
            ps.executeUpdate();
        }
    }

    protected void writePubkey(PreparedStatement ps, int parameterIndex, Pubkey data) throws SQLException, IOException {
        if (data != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            data.writeUnencrypted((OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ps.setBlob(parameterIndex, in);
        } else {
            ps.setBlob(parameterIndex, (Blob)null);
        }
    }

    public void remove(BitmessageAddress address) {
        try (Connection connection = this.config.getConnection();){
            Statement stmt = connection.createStatement();
            stmt.executeUpdate("DELETE FROM Address WHERE address = '" + address.getAddress() + "'");
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public BitmessageAddress getAddress(String address) {
        List<BitmessageAddress> result = this.find("address = '" + address + "'");
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }
}

