/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.networking.nio;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.CustomMessage;
import ch.dissem.bitmessage.entity.GetData;
import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.NetworkMessage;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.exception.NodeException;
import ch.dissem.bitmessage.factory.V3MessageReader;
import ch.dissem.bitmessage.networking.AbstractConnection;
import ch.dissem.bitmessage.networking.nio.ConnectionInfo;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.utils.Collections;
import ch.dissem.bitmessage.utils.DebugUtils;
import ch.dissem.bitmessage.utils.Property;
import ch.dissem.bitmessage.utils.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioNetworkHandler
implements NetworkHandler,
InternalContext.ContextHolder {
    private static final Logger LOG = LoggerFactory.getLogger(NioNetworkHandler.class);
    private static final long REQUESTED_OBJECTS_MAX_TIME = 1800000L;
    private final ExecutorService threadPool = Executors.newCachedThreadPool(ThreadFactoryBuilder.pool((String)"network").lowPrio().daemon().build());
    private InternalContext ctx;
    private Selector selector;
    private ServerSocketChannel serverChannel;
    private Queue<NetworkAddress> connectionQueue = new ConcurrentLinkedQueue<NetworkAddress>();
    private Map<ConnectionInfo, SelectionKey> connections = new ConcurrentHashMap<ConnectionInfo, SelectionKey>();
    private final Set<InventoryVector> requestedObjects = java.util.Collections.newSetFromMap(new ConcurrentHashMap(10000));
    private long requestedObjectsTimeout = 0L;
    private Thread starter;

    public Future<Void> synchronize(final InetAddress server, final int port, final long timeoutInSeconds) {
        return this.threadPool.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (SocketChannel channel = SocketChannel.open(new InetSocketAddress(server, port));){
                    channel.configureBlocking(false);
                    ConnectionInfo connection = new ConnectionInfo(NioNetworkHandler.this.ctx, AbstractConnection.Mode.SYNC, new NetworkAddress.Builder().ip(server).port(port).stream(1L).build(), new HashSet<InventoryVector>(), timeoutInSeconds);
                    while (channel.isConnected() && !connection.isSyncFinished()) {
                        NioNetworkHandler.write(channel, connection);
                        NioNetworkHandler.read(channel, connection);
                        Thread.sleep(10L);
                    }
                    LOG.info("Synchronization finished");
                }
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CustomMessage send(InetAddress server, int port, CustomMessage request) {
        try (SocketChannel channel = SocketChannel.open(new InetSocketAddress(server, port));){
            channel.configureBlocking(true);
            ByteBuffer headerBuffer = ByteBuffer.allocate(24);
            ByteBuffer payloadBuffer = new NetworkMessage((MessagePayload)request).writeHeaderAndGetPayloadBuffer(headerBuffer);
            headerBuffer.flip();
            while (headerBuffer.hasRemaining()) {
                channel.write(headerBuffer);
            }
            while (payloadBuffer.hasRemaining()) {
                channel.write(payloadBuffer);
            }
            V3MessageReader reader = new V3MessageReader();
            while (channel.isConnected() && reader.getMessages().isEmpty()) {
                if (channel.read(reader.getActiveBuffer()) <= 0) throw new NodeException("No response from node " + server);
                reader.update();
            }
            if (reader.getMessages().isEmpty()) {
                throw new NodeException("No response from node " + server);
            }
            NetworkMessage networkMessage = (NetworkMessage)reader.getMessages().get(0);
            if (networkMessage != null && networkMessage.getPayload() instanceof CustomMessage) {
                CustomMessage customMessage = (CustomMessage)networkMessage.getPayload();
                return customMessage;
            }
            if (networkMessage == null) throw new NodeException("Empty response from node " + server);
            if (networkMessage.getPayload() != null) throw new NodeException("Unexpected response from node " + server + ": " + networkMessage.getPayload().getClass());
            throw new NodeException("Empty response from node " + server);
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public void start() {
        if (this.selector != null && this.selector.isOpen()) {
            throw new IllegalStateException("Network already running - you need to stop first.");
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
        this.requestedObjectsTimeout = System.currentTimeMillis() + 1800000L;
        this.requestedObjects.clear();
        this.starter = this.thread("connection manager", new Runnable(){

            @Override
            public void run() {
                while (NioNetworkHandler.this.selector.isOpen()) {
                    Object connectionInfo;
                    int missing = 8;
                    Iterator iterator = NioNetworkHandler.this.connections.keySet().iterator();
                    while (iterator.hasNext() && (((ConnectionInfo)(connectionInfo = (ConnectionInfo)iterator.next())).getState() != AbstractConnection.State.ACTIVE || --missing != 0)) {
                    }
                    if (missing > 0) {
                        List addresses = NioNetworkHandler.this.ctx.getNodeRegistry().getKnownAddresses(100, NioNetworkHandler.this.ctx.getStreams());
                        addresses = Collections.selectRandom((int)missing, (Collection)addresses);
                        connectionInfo = addresses.iterator();
                        while (connectionInfo.hasNext()) {
                            NetworkAddress address = (NetworkAddress)connectionInfo.next();
                            if (NioNetworkHandler.this.isConnectedTo(address)) continue;
                            NioNetworkHandler.this.connectionQueue.offer(address);
                        }
                    }
                    Iterator it = NioNetworkHandler.this.connections.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry e = it.next();
                        if (((SelectionKey)e.getValue()).isValid() && !((ConnectionInfo)e.getKey()).isExpired()) continue;
                        try {
                            ((SelectionKey)e.getValue()).channel().close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ((SelectionKey)e.getValue()).cancel();
                        ((SelectionKey)e.getValue()).attach(null);
                        ((ConnectionInfo)e.getKey()).disconnect();
                        it.remove();
                    }
                    long now = System.currentTimeMillis();
                    if (now > NioNetworkHandler.this.requestedObjectsTimeout) {
                        NioNetworkHandler.this.requestedObjectsTimeout = now + 1800000L;
                        NioNetworkHandler.this.requestedObjects.clear();
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        this.thread("selector worker", new Runnable(){

            @Override
            public void run() {
                try {
                    NioNetworkHandler.this.serverChannel = ServerSocketChannel.open();
                    NioNetworkHandler.this.serverChannel.configureBlocking(false);
                    NioNetworkHandler.this.serverChannel.socket().bind(new InetSocketAddress(NioNetworkHandler.this.ctx.getPort()));
                    NioNetworkHandler.this.serverChannel.register(NioNetworkHandler.this.selector, 16, null);
                    while (NioNetworkHandler.this.selector.isOpen()) {
                        ConnectionInfo connection;
                        NioNetworkHandler.this.selector.select(1000L);
                        Iterator<SelectionKey> keyIterator = NioNetworkHandler.this.selector.selectedKeys().iterator();
                        while (keyIterator.hasNext()) {
                            SelectionKey key = keyIterator.next();
                            keyIterator.remove();
                            if (key.attachment() == null) {
                                try {
                                    if (!key.isAcceptable()) continue;
                                    try {
                                        SocketChannel socketChannel = ((ServerSocketChannel)key.channel()).accept();
                                        socketChannel.configureBlocking(false);
                                        connection = new ConnectionInfo(NioNetworkHandler.this.ctx, AbstractConnection.Mode.SERVER, new NetworkAddress.Builder().ip(socketChannel.socket().getInetAddress()).port(socketChannel.socket().getPort()).stream(1L).build(), NioNetworkHandler.this.requestedObjects, 0L);
                                        NioNetworkHandler.this.connections.put(connection, socketChannel.register(NioNetworkHandler.this.selector, 5, connection));
                                    }
                                    catch (AsynchronousCloseException asynchronousCloseException) {
                                        LOG.trace(asynchronousCloseException.getMessage());
                                    }
                                    catch (IOException iOException) {
                                        LOG.error(iOException.getMessage(), (Throwable)iOException);
                                    }
                                }
                                catch (CancelledKeyException cancelledKeyException) {
                                    LOG.error(cancelledKeyException.getMessage(), (Throwable)cancelledKeyException);
                                }
                                continue;
                            }
                            SocketChannel socketChannel = (SocketChannel)key.channel();
                            connection = (ConnectionInfo)key.attachment();
                            try {
                                if (key.isConnectable() && !socketChannel.finishConnect()) continue;
                                if (key.isWritable()) {
                                    NioNetworkHandler.write(socketChannel, connection);
                                }
                                if (key.isReadable()) {
                                    NioNetworkHandler.read(socketChannel, connection);
                                }
                                if (connection.getState() == AbstractConnection.State.DISCONNECTED) {
                                    key.interestOps(0);
                                    socketChannel.close();
                                    continue;
                                }
                                if (connection.isWritePending()) {
                                    key.interestOps(5);
                                    continue;
                                }
                                key.interestOps(1);
                            }
                            catch (NodeException | IOException | CancelledKeyException e) {
                                connection.disconnect();
                            }
                        }
                        for (Map.Entry entry : NioNetworkHandler.this.connections.entrySet()) {
                            if (!((SelectionKey)entry.getValue()).isValid() || (((SelectionKey)entry.getValue()).interestOps() & 4) != 0 || (((SelectionKey)entry.getValue()).interestOps() & 8) != 0 || ((ConnectionInfo)entry.getKey()).getSendingQueue().isEmpty()) continue;
                            ((SelectionKey)entry.getValue()).interestOps(5);
                        }
                        if (NioNetworkHandler.this.connectionQueue.isEmpty()) continue;
                        NetworkAddress address = (NetworkAddress)NioNetworkHandler.this.connectionQueue.poll();
                        try {
                            SocketChannel socketChannel = SocketChannel.open();
                            socketChannel.configureBlocking(false);
                            socketChannel.connect(new InetSocketAddress(address.toInetAddress(), address.getPort()));
                            connection = new ConnectionInfo(NioNetworkHandler.this.ctx, AbstractConnection.Mode.CLIENT, address, NioNetworkHandler.this.requestedObjects, 0L);
                            NioNetworkHandler.this.connections.put(connection, socketChannel.register(NioNetworkHandler.this.selector, 8, connection));
                        }
                        catch (NoRouteToHostException noRouteToHostException) {
                        }
                        catch (AsynchronousCloseException asynchronousCloseException) {
                            if (!NioNetworkHandler.this.isRunning()) continue;
                            LOG.error(asynchronousCloseException.getMessage(), (Throwable)asynchronousCloseException);
                        }
                        catch (IOException iOException) {
                            LOG.error(iOException.getMessage(), (Throwable)iOException);
                        }
                    }
                    NioNetworkHandler.this.selector.close();
                }
                catch (ClosedSelectorException keyIterator) {
                }
                catch (IOException e) {
                    throw new ApplicationException((Throwable)e);
                }
            }
        });
    }

    private static void write(SocketChannel channel, ConnectionInfo connection) throws IOException {
        NioNetworkHandler.writeBuffer(connection.getOutBuffers(), channel);
        connection.updateWriter();
        NioNetworkHandler.writeBuffer(connection.getOutBuffers(), channel);
        connection.cleanupBuffers();
    }

    private static void writeBuffer(ByteBuffer[] buffers, SocketChannel channel) throws IOException {
        if (buffers[1] == null) {
            if (buffers[0].hasRemaining()) {
                channel.write(buffers[0]);
            }
        } else if (buffers[1].hasRemaining() || buffers[0].hasRemaining()) {
            channel.write(buffers);
        }
    }

    private static void read(SocketChannel channel, ConnectionInfo connection) throws IOException {
        if (channel.read(connection.getInBuffer()) > 0) {
            connection.updateReader();
        }
        connection.updateSyncStatus();
    }

    private Thread thread(String threadName, Runnable runnable) {
        Thread thread = new Thread(runnable, threadName);
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
        return thread;
    }

    public void stop() {
        try {
            this.serverChannel.socket().close();
            this.selector.close();
            for (SelectionKey selectionKey : this.connections.values()) {
                selectionKey.channel().close();
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public void offer(InventoryVector iv) {
        LinkedList<ConnectionInfo> target = new LinkedList<ConnectionInfo>();
        for (ConnectionInfo connection : this.connections.keySet()) {
            if (connection.getState() != AbstractConnection.State.ACTIVE || connection.knowsOf(iv)) continue;
            target.add(connection);
        }
        List randomSubset = Collections.selectRandom((int)8, target);
        for (ConnectionInfo connection : randomSubset) {
            connection.offer(iv);
        }
    }

    public void request(Collection<InventoryVector> inventoryVectors) {
        List ivs;
        if (!this.isRunning()) {
            this.requestedObjects.clear();
            return;
        }
        Iterator<InventoryVector> iterator = inventoryVectors.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        HashMap distribution = new HashMap();
        for (ConnectionInfo connection : this.connections.keySet()) {
            if (connection.getState() != AbstractConnection.State.ACTIVE) continue;
            distribution.put(connection, new LinkedList());
        }
        if (distribution.isEmpty()) {
            return;
        }
        InventoryVector next = iterator.next();
        ConnectionInfo previous = null;
        block1: do {
            for (ConnectionInfo connection : distribution.keySet()) {
                if (connection == previous || previous == null) {
                    if (!iterator.hasNext()) continue block1;
                    previous = connection;
                    next = iterator.next();
                }
                if (!connection.knowsOf(next)) continue;
                ivs = (List)distribution.get(connection);
                if (ivs.size() == 50000) {
                    connection.send((MessagePayload)new GetData.Builder().inventory(ivs).build());
                    ivs.clear();
                }
                ivs.add(next);
                iterator.remove();
                if (!iterator.hasNext()) continue block1;
                next = iterator.next();
                previous = connection;
            }
        } while (iterator.hasNext());
        this.requestedObjects.removeAll(inventoryVectors);
        for (ConnectionInfo connection : distribution.keySet()) {
            ivs = (List)distribution.get(connection);
            if (ivs.isEmpty()) continue;
            connection.send((MessagePayload)new GetData.Builder().inventory(ivs).build());
        }
    }

    public Property getNetworkStatus() {
        TreeSet<Long> streams = new TreeSet<Long>();
        TreeMap incomingConnections = new TreeMap();
        TreeMap outgoingConnections = new TreeMap();
        for (ConnectionInfo connection : this.connections.keySet()) {
            if (connection.getState() != AbstractConnection.State.ACTIVE) continue;
            for (Object stream : (Object)connection.getStreams()) {
                streams.add((long)stream);
                if (connection.getMode() == AbstractConnection.Mode.SERVER) {
                    DebugUtils.inc(incomingConnections, (Object)((long)stream));
                    continue;
                }
                DebugUtils.inc(outgoingConnections, (Object)((long)stream));
            }
        }
        Property[] streamProperties = new Property[streams.size()];
        int i = 0;
        for (Long stream : streams) {
            int incoming = incomingConnections.containsKey(stream) ? (Integer)incomingConnections.get(stream) : 0;
            int outgoing = outgoingConnections.containsKey(stream) ? (Integer)outgoingConnections.get(stream) : 0;
            streamProperties[i] = new Property("stream " + stream, null, new Property[]{new Property("nodes", (Object)(incoming + outgoing), new Property[0]), new Property("incoming", (Object)incoming, new Property[0]), new Property("outgoing", (Object)outgoing, new Property[0])});
            ++i;
        }
        return new Property("network", null, new Property[]{new Property("connectionManager", (Object)(this.isRunning() ? "running" : "stopped"), new Property[0]), new Property("connections", null, streamProperties), new Property("requestedObjects", (Object)this.requestedObjects.size(), new Property[0])});
    }

    private boolean isConnectedTo(NetworkAddress address) {
        for (ConnectionInfo c : this.connections.keySet()) {
            if (!c.getNode().equals((Object)address)) continue;
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        return this.selector != null && this.selector.isOpen() && this.starter.isAlive();
    }

    public void setContext(InternalContext context) {
        this.ctx = context;
    }
}

