/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.networking;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.networking.AbstractConnection;
import ch.dissem.bitmessage.networking.Connection;
import ch.dissem.bitmessage.networking.DefaultNetworkHandler;
import ch.dissem.bitmessage.ports.NetworkHandler;
import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerRunnable
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ServerRunnable.class);
    private final InternalContext ctx;
    private final ServerSocket serverSocket;
    private final DefaultNetworkHandler networkHandler;
    private final NetworkHandler.MessageListener listener;

    public ServerRunnable(InternalContext ctx, DefaultNetworkHandler networkHandler) throws IOException {
        this.ctx = ctx;
        this.networkHandler = networkHandler;
        this.listener = ctx.getNetworkListener();
        this.serverSocket = new ServerSocket(ctx.getPort());
    }

    @Override
    public void run() {
        while (!this.serverSocket.isClosed()) {
            try {
                Socket socket = this.serverSocket.accept();
                socket.setSoTimeout(2000);
                this.networkHandler.startConnection(new Connection(this.ctx, AbstractConnection.Mode.SERVER, socket, this.networkHandler.requestedObjects));
            }
            catch (IOException e) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
        }
    }
}

