/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.networking;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.CustomMessage;
import ch.dissem.bitmessage.entity.GetData;
import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.NetworkMessage;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.exception.NodeException;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.networking.AbstractConnection;
import ch.dissem.bitmessage.networking.Connection;
import ch.dissem.bitmessage.networking.ConnectionOrganizer;
import ch.dissem.bitmessage.networking.ServerRunnable;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.utils.DebugUtils;
import ch.dissem.bitmessage.utils.Property;
import ch.dissem.bitmessage.utils.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Deprecated
public class DefaultNetworkHandler
implements NetworkHandler,
InternalContext.ContextHolder {
    final Collection<Connection> connections = new ConcurrentLinkedQueue<Connection>();
    private final ExecutorService pool = Executors.newCachedThreadPool(ThreadFactoryBuilder.pool((String)"network").lowPrio().daemon().build());
    private InternalContext ctx;
    private ServerRunnable server;
    private volatile boolean running;
    final Set<InventoryVector> requestedObjects = Collections.newSetFromMap(new ConcurrentHashMap(50000));

    public void setContext(InternalContext context) {
        this.ctx = context;
    }

    public Future<?> synchronize(InetAddress server, int port, long timeoutInSeconds) {
        try {
            Connection connection = Connection.sync(this.ctx, server, port, this.ctx.getNetworkListener(), timeoutInSeconds);
            Future<?> reader = this.pool.submit(connection.getReader());
            this.pool.execute(connection.getWriter());
            return reader;
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CustomMessage send(InetAddress server, int port, CustomMessage request) {
        try (Socket socket = new Socket(server, port);){
            socket.setSoTimeout(2000);
            new NetworkMessage((MessagePayload)request).write(socket.getOutputStream());
            NetworkMessage networkMessage = Factory.getNetworkMessage((int)3, (InputStream)socket.getInputStream());
            if (networkMessage != null && networkMessage.getPayload() instanceof CustomMessage) {
                CustomMessage customMessage = (CustomMessage)networkMessage.getPayload();
                return customMessage;
            }
            if (networkMessage != null) throw new NodeException("Unexpected response from node " + server + ": " + networkMessage.getPayload().getCommand());
            throw new NodeException("No response from node " + server);
        }
        catch (IOException e) {
            throw new NodeException(e.getMessage(), (Throwable)e);
        }
    }

    public void start() {
        if (this.running) {
            throw new IllegalStateException("Network already running - you need to stop first.");
        }
        try {
            this.running = true;
            this.connections.clear();
            this.server = new ServerRunnable(this.ctx, this);
            this.pool.execute(this.server);
            this.pool.execute(new ConnectionOrganizer(this.ctx, this));
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.server.close();
        Collection<Connection> collection = this.connections;
        synchronized (collection) {
            this.running = false;
            for (Connection c : this.connections) {
                c.disconnect();
            }
        }
        this.requestedObjects.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startConnection(Connection c) {
        if (!this.running) {
            return;
        }
        Collection<Connection> collection = this.connections;
        synchronized (collection) {
            if (!this.running) {
                return;
            }
            if (this.connections.contains(c)) {
                return;
            }
            this.connections.add(c);
        }
        this.pool.execute(c.getReader());
        this.pool.execute(c.getWriter());
    }

    public void offer(InventoryVector iv) {
        LinkedList<Connection> target = new LinkedList<Connection>();
        for (Connection connection : this.connections) {
            if (connection.getState() != AbstractConnection.State.ACTIVE || connection.knowsOf(iv)) continue;
            target.add(connection);
        }
        List randomSubset = ch.dissem.bitmessage.utils.Collections.selectRandom((int)8, target);
        for (Connection connection : randomSubset) {
            connection.offer(iv);
        }
    }

    public Property getNetworkStatus() {
        TreeSet<Long> streams = new TreeSet<Long>();
        TreeMap incomingConnections = new TreeMap();
        TreeMap outgoingConnections = new TreeMap();
        for (Connection connection : this.connections) {
            if (connection.getState() != AbstractConnection.State.ACTIVE) continue;
            for (Object stream : (Object)connection.getStreams()) {
                streams.add((long)stream);
                if (connection.getMode() == AbstractConnection.Mode.SERVER) {
                    DebugUtils.inc(incomingConnections, (Object)((long)stream));
                    continue;
                }
                DebugUtils.inc(outgoingConnections, (Object)((long)stream));
            }
        }
        Property[] streamProperties = new Property[streams.size()];
        int i = 0;
        for (Long stream : streams) {
            int incoming = incomingConnections.containsKey(stream) ? (Integer)incomingConnections.get(stream) : 0;
            int outgoing = outgoingConnections.containsKey(stream) ? (Integer)outgoingConnections.get(stream) : 0;
            streamProperties[i] = new Property("stream " + stream, null, new Property[]{new Property("nodes", (Object)(incoming + outgoing), new Property[0]), new Property("incoming", (Object)incoming, new Property[0]), new Property("outgoing", (Object)outgoing, new Property[0])});
            ++i;
        }
        return new Property("network", null, new Property[]{new Property("connectionManager", (Object)(this.running ? "running" : "stopped"), new Property[0]), new Property("connections", null, streamProperties), new Property("requestedObjects", (Object)this.requestedObjects.size(), new Property[0])});
    }

    public void request(Collection<InventoryVector> inventoryVectors) {
        List ivs;
        if (!this.running || inventoryVectors.isEmpty()) {
            return;
        }
        HashMap distribution = new HashMap();
        for (Connection connection : this.connections) {
            if (connection.getState() != AbstractConnection.State.ACTIVE) continue;
            distribution.put(connection, new LinkedList());
        }
        Iterator<InventoryVector> iterator = inventoryVectors.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        InventoryVector next = iterator.next();
        Connection previous = null;
        block1: do {
            for (Connection connection : distribution.keySet()) {
                if (connection == previous) {
                    next = iterator.next();
                }
                if (!connection.knowsOf(next)) continue;
                ivs = (List)distribution.get(connection);
                if (ivs.size() == 50000) {
                    connection.send((MessagePayload)new GetData.Builder().inventory(ivs).build());
                    ivs.clear();
                }
                ivs.add(next);
                iterator.remove();
                if (!iterator.hasNext()) continue block1;
                next = iterator.next();
                previous = connection;
            }
        } while (iterator.hasNext());
        for (Connection connection : distribution.keySet()) {
            ivs = (List)distribution.get(connection);
            if (ivs.isEmpty()) continue;
            connection.send((MessagePayload)new GetData.Builder().inventory(ivs).build());
        }
    }
}

