/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.networking;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.networking.AbstractConnection;
import ch.dissem.bitmessage.networking.Connection;
import ch.dissem.bitmessage.networking.DefaultNetworkHandler;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.utils.UnixTime;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionOrganizer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionOrganizer.class);
    private final InternalContext ctx;
    private final DefaultNetworkHandler networkHandler;
    private final NetworkHandler.MessageListener listener;
    private Connection initialConnection;

    public ConnectionOrganizer(InternalContext ctx, DefaultNetworkHandler networkHandler) {
        this.ctx = ctx;
        this.networkHandler = networkHandler;
        this.listener = ctx.getNetworkListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.networkHandler.isRunning()) {
                try {
                    int active = 0;
                    long now = UnixTime.now();
                    int diff = this.networkHandler.connections.size() - this.ctx.getConnectionLimit();
                    if (diff > 0) {
                        for (Connection c : this.networkHandler.connections) {
                            c.disconnect();
                            if (--diff != 0) continue;
                        }
                    }
                    boolean forcedDisconnect = false;
                    Iterator<Connection> iterator = this.networkHandler.connections.iterator();
                    while (iterator.hasNext()) {
                        Connection c = iterator.next();
                        if (!forcedDisconnect && now - c.getStartTime() > this.ctx.getConnectionTTL()) {
                            c.disconnect();
                            forcedDisconnect = true;
                        }
                        switch (c.getState()) {
                            case DISCONNECTED: {
                                iterator.remove();
                                break;
                            }
                            case ACTIVE: {
                                ++active;
                                break;
                            }
                        }
                    }
                    if (active < 8) {
                        List addresses = this.ctx.getNodeRegistry().getKnownAddresses(8 - active, this.ctx.getStreams());
                        boolean first = active == 0 && this.initialConnection == null;
                        for (NetworkAddress address : addresses) {
                            Connection c = new Connection(this.ctx, AbstractConnection.Mode.CLIENT, address, this.networkHandler.requestedObjects);
                            if (first) {
                                this.initialConnection = c;
                                first = false;
                            }
                            this.networkHandler.startConnection(c);
                        }
                        Thread.sleep(10000L);
                        continue;
                    }
                    if (this.initialConnection == null) {
                        Thread.sleep(30000L);
                        continue;
                    }
                    this.initialConnection.disconnect();
                    this.initialConnection = null;
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    this.networkHandler.stop();
                }
                catch (Exception e) {
                    LOG.error("Error in connection manager. Ignored.", (Throwable)e);
                }
            }
            return;
        }
        finally {
            LOG.debug("Connection manager shutting down.");
            this.networkHandler.stop();
        }
    }
}

