/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.networking;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.GetData;
import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.NetworkMessage;
import ch.dissem.bitmessage.entity.Version;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.networking.AbstractConnection;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.utils.UnixTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connection
extends AbstractConnection {
    public static final int READ_TIMEOUT = 2000;
    private static final Logger LOG = LoggerFactory.getLogger(Connection.class);
    private static final int CONNECT_TIMEOUT = 5000;
    private final long startTime;
    private final Socket socket;
    private final ReaderRunnable reader = new ReaderRunnable();
    private final WriterRunnable writer = new WriterRunnable();
    private InputStream in;
    private OutputStream out;
    private boolean socketInitialized;

    public Connection(InternalContext context, AbstractConnection.Mode mode, Socket socket, Set<InventoryVector> requestedObjectsMap) throws IOException {
        this(context, mode, socket, requestedObjectsMap, new NetworkAddress.Builder().ip(socket.getInetAddress()).port(socket.getPort()).stream(1L).build(), 0L);
    }

    public Connection(InternalContext context, AbstractConnection.Mode mode, NetworkAddress node, Set<InventoryVector> requestedObjectsMap) {
        this(context, mode, new Socket(), requestedObjectsMap, node, 0L);
    }

    private Connection(InternalContext context, AbstractConnection.Mode mode, Socket socket, Set<InventoryVector> commonRequestedObjects, NetworkAddress node, long syncTimeout) {
        super(context, mode, node, commonRequestedObjects, syncTimeout);
        this.startTime = UnixTime.now();
        this.socket = socket;
    }

    public static Connection sync(InternalContext ctx, InetAddress address, int port, NetworkHandler.MessageListener listener, long timeoutInSeconds) throws IOException {
        return new Connection(ctx, AbstractConnection.Mode.SYNC, new Socket(address, port), new HashSet<InventoryVector>(), new NetworkAddress.Builder().ip(address).port(port).stream(1L).build(), timeoutInSeconds);
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public AbstractConnection.Mode getMode() {
        return this.mode;
    }

    @Override
    public AbstractConnection.State getState() {
        return this.state;
    }

    @Override
    public NetworkAddress getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void send(MessagePayload payload) {
        try {
            if (payload instanceof GetData) {
                this.requestedObjects.addAll(((GetData)payload).getInventory());
            }
            Connection connection = this;
            synchronized (connection) {
                new NetworkMessage(payload).write(this.out);
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.disconnect();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        return Objects.equals(this.node, that.node);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.node);
    }

    private synchronized void initSocket(Socket socket) throws IOException {
        if (!this.socketInitialized) {
            if (!socket.isConnected()) {
                LOG.trace("Trying to connect to node " + this.node);
                socket.connect(new InetSocketAddress(this.node.toInetAddress(), this.node.getPort()), 5000);
            }
            socket.setSoTimeout(2000);
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
            this.socketInitialized = true;
        }
    }

    public ReaderRunnable getReader() {
        return this.reader;
    }

    public WriterRunnable getWriter() {
        return this.writer;
    }

    private boolean checkOpenRequests() {
        return !this.requestedObjects.isEmpty() && this.lastObjectTime > 0L && UnixTime.now() - this.lastObjectTime > 120L;
    }

    public class WriterRunnable
    implements Runnable {
        @Override
        public void run() {
            try (Socket socket = Connection.this.socket;){
                Connection.this.initSocket(socket);
                while (Connection.this.state != AbstractConnection.State.DISCONNECTED) {
                    if (Connection.this.sendingQueue.isEmpty()) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    Connection.this.send((MessagePayload)Connection.this.sendingQueue.poll());
                }
            }
            catch (IOException | InterruptedException e) {
                LOG.trace("Writer disconnected from node " + Connection.this.node + ": " + e.getMessage());
                Connection.this.disconnect();
            }
        }
    }

    public class ReaderRunnable
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (Socket socket = Connection.this.socket;){
                Connection.this.initSocket(socket);
                if (Connection.this.mode == AbstractConnection.Mode.CLIENT || Connection.this.mode == AbstractConnection.Mode.SYNC) {
                    Connection.this.send((MessagePayload)new Version.Builder().defaults(Connection.this.ctx.getClientNonce()).addrFrom(Connection.this.host).addrRecv(Connection.this.node).build());
                }
                while (Connection.this.state != AbstractConnection.State.DISCONNECTED) {
                    if (Connection.this.mode != AbstractConnection.Mode.SYNC) {
                        if (Connection.this.state == AbstractConnection.State.ACTIVE && Connection.this.requestedObjects.isEmpty() && Connection.this.sendingQueue.isEmpty()) {
                            Thread.sleep(1000L);
                        } else {
                            Thread.sleep(100L);
                        }
                    }
                    this.receive();
                }
            }
            catch (Exception e) {
                LOG.trace("Reader disconnected from node " + Connection.this.node + ": " + e.getMessage());
            }
            finally {
                Connection.this.disconnect();
                try {
                    Connection.this.socket.close();
                }
                catch (Exception e) {
                    LOG.debug(e.getMessage(), (Throwable)e);
                }
            }
        }

        private void receive() throws InterruptedException {
            block4: {
                try {
                    NetworkMessage msg = Factory.getNetworkMessage((int)Connection.this.version, (InputStream)Connection.this.in);
                    if (msg == null) {
                        return;
                    }
                    Connection.this.handleMessage(msg.getPayload());
                    if (Connection.this.socket.isClosed() || Connection.this.syncFinished(msg) || Connection.this.checkOpenRequests()) {
                        Connection.this.disconnect();
                    }
                }
                catch (SocketTimeoutException ignore) {
                    if (Connection.this.state != AbstractConnection.State.ACTIVE || !Connection.this.syncFinished(null)) break block4;
                    Connection.this.disconnect();
                }
            }
        }
    }
}

