/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.networking.nio;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.GetData;
import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.NetworkMessage;
import ch.dissem.bitmessage.entity.Version;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.exception.NodeException;
import ch.dissem.bitmessage.factory.V3MessageReader;
import ch.dissem.bitmessage.networking.AbstractConnection;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

public class ConnectionInfo
extends AbstractConnection {
    private final ByteBuffer headerOut = ByteBuffer.allocate(24);
    private ByteBuffer payloadOut;
    private V3MessageReader reader = new V3MessageReader();
    private boolean syncFinished;
    private long lastUpdate = System.currentTimeMillis();

    public ConnectionInfo(InternalContext context, AbstractConnection.Mode mode, NetworkAddress node, Set<InventoryVector> commonRequestedObjects, long syncTimeout) {
        super(context, mode, node, commonRequestedObjects, syncTimeout);
        this.headerOut.flip();
        if (mode == AbstractConnection.Mode.CLIENT || mode == AbstractConnection.Mode.SYNC) {
            this.send((MessagePayload)new Version.Builder().defaults(this.ctx.getClientNonce()).addrFrom(this.host).addrRecv(node).build());
        }
    }

    @Override
    public AbstractConnection.State getState() {
        return this.state;
    }

    @Override
    public boolean knowsOf(InventoryVector iv) {
        return this.ivCache.containsKey(iv);
    }

    public Queue<MessagePayload> getSendingQueue() {
        return this.sendingQueue;
    }

    public ByteBuffer getInBuffer() {
        if (this.reader == null) {
            throw new NodeException("Node is disconnected");
        }
        return this.reader.getActiveBuffer();
    }

    public void updateWriter() {
        if (!this.headerOut.hasRemaining() && !this.sendingQueue.isEmpty()) {
            this.headerOut.clear();
            MessagePayload payload = (MessagePayload)this.sendingQueue.poll();
            this.payloadOut = new NetworkMessage(payload).writeHeaderAndGetPayloadBuffer(this.headerOut);
            this.headerOut.flip();
            this.lastUpdate = System.currentTimeMillis();
        }
    }

    public ByteBuffer[] getOutBuffers() {
        return new ByteBuffer[]{this.headerOut, this.payloadOut};
    }

    public void cleanupBuffers() {
        if (this.payloadOut != null && !this.payloadOut.hasRemaining()) {
            this.payloadOut = null;
        }
    }

    public void updateReader() {
        this.reader.update();
        if (!this.reader.getMessages().isEmpty()) {
            Iterator iterator = this.reader.getMessages().iterator();
            NetworkMessage msg = null;
            while (iterator.hasNext()) {
                msg = (NetworkMessage)iterator.next();
                this.handleMessage(msg.getPayload());
                iterator.remove();
            }
            this.syncFinished = this.syncFinished(msg);
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void updateSyncStatus() {
        if (!this.syncFinished) {
            this.syncFinished = (this.reader == null || this.reader.getMessages().isEmpty()) && this.syncFinished(null);
        }
    }

    public boolean isExpired() {
        switch (this.state) {
            case CONNECTING: {
                return this.lastUpdate < System.currentTimeMillis() - 20000L;
            }
            case ACTIVE: {
                return this.lastUpdate < System.currentTimeMillis() - 600000L;
            }
            case DISCONNECTED: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)this.state));
    }

    @Override
    public void disconnect() {
        super.disconnect();
        if (this.reader != null) {
            this.reader.cleanup();
            this.reader = null;
        }
        this.payloadOut = null;
    }

    public boolean isSyncFinished() {
        return this.syncFinished;
    }

    @Override
    protected void send(MessagePayload payload) {
        this.sendingQueue.add(payload);
        if (payload instanceof GetData) {
            this.requestedObjects.addAll(((GetData)payload).getInventory());
            this.commonRequestedObjects.addAll(((GetData)payload).getInventory());
        }
    }

    public boolean isWritePending() {
        return !this.sendingQueue.isEmpty() || this.headerOut != null && this.headerOut.hasRemaining() || this.payloadOut != null && this.payloadOut.hasRemaining();
    }
}

