/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.extensions.pow;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.extensions.CryptoCustomMessage;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class ProofOfWorkRequest
implements Streamable {
    private final BitmessageAddress sender;
    private final byte[] initialHash;
    private final Request request;
    private final byte[] data;

    public ProofOfWorkRequest(BitmessageAddress sender, byte[] initialHash, Request request) {
        this(sender, initialHash, request, new byte[0]);
    }

    public ProofOfWorkRequest(BitmessageAddress sender, byte[] initialHash, Request request, byte[] data) {
        this.sender = sender;
        this.initialHash = initialHash;
        this.request = request;
        this.data = data;
    }

    public static ProofOfWorkRequest read(BitmessageAddress client, InputStream in) throws IOException {
        return new ProofOfWorkRequest(client, Decode.bytes((InputStream)in, (int)64), Request.valueOf(Decode.varString((InputStream)in)), Decode.varBytes((InputStream)in));
    }

    public BitmessageAddress getSender() {
        return this.sender;
    }

    public byte[] getInitialHash() {
        return this.initialHash;
    }

    public Request getRequest() {
        return this.request;
    }

    public byte[] getData() {
        return this.data;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.initialHash);
        Encode.varString((String)this.request.name(), (OutputStream)out);
        Encode.varBytes((byte[])this.data, (OutputStream)out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProofOfWorkRequest other = (ProofOfWorkRequest)o;
        if (!this.sender.equals((Object)other.sender)) {
            return false;
        }
        if (!Arrays.equals(this.initialHash, other.initialHash)) {
            return false;
        }
        if (this.request != other.request) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int result = this.sender.hashCode();
        result = 31 * result + Arrays.hashCode(this.initialHash);
        result = 31 * result + this.request.hashCode();
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public static enum Request {
        CALCULATE,
        CALCULATING,
        COMPLETE;

    }

    public static class Reader
    implements CryptoCustomMessage.Reader<ProofOfWorkRequest> {
        private final BitmessageAddress identity;

        public Reader(BitmessageAddress identity) {
            this.identity = identity;
        }

        @Override
        public ProofOfWorkRequest read(BitmessageAddress sender, InputStream in) throws IOException {
            return ProofOfWorkRequest.read(this.identity, in);
        }
    }
}

