/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.extensions;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.CustomMessage;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.payload.CryptoBox;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.exception.DecryptionFailedException;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CryptoCustomMessage<T extends Streamable>
extends CustomMessage {
    public static final String COMMAND = "ENCRYPTED";
    private final Reader<T> dataReader;
    private CryptoBox container;
    private BitmessageAddress sender;
    private T data;

    public CryptoCustomMessage(T data) throws IOException {
        super(COMMAND);
        this.data = data;
        this.dataReader = null;
    }

    private CryptoCustomMessage(CryptoBox container, Reader<T> dataReader) {
        super(COMMAND);
        this.container = container;
        this.dataReader = dataReader;
    }

    public static <T extends Streamable> CryptoCustomMessage<T> read(CustomMessage data, Reader<T> dataReader) throws IOException {
        CryptoBox cryptoBox = CryptoBox.read((InputStream)new ByteArrayInputStream(data.getData()), (int)data.getData().length);
        return new CryptoCustomMessage<T>(cryptoBox, dataReader);
    }

    public BitmessageAddress getSender() {
        return this.sender;
    }

    public void signAndEncrypt(BitmessageAddress identity, byte[] publicKey) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encode.varInt((long)identity.getVersion(), (OutputStream)out);
        Encode.varInt((long)identity.getStream(), (OutputStream)out);
        Encode.int32((long)identity.getPubkey().getBehaviorBitfield(), (OutputStream)out);
        out.write(identity.getPubkey().getSigningKey(), 1, 64);
        out.write(identity.getPubkey().getEncryptionKey(), 1, 64);
        if (identity.getVersion() >= 3L) {
            Encode.varInt((long)identity.getPubkey().getNonceTrialsPerByte(), (OutputStream)out);
            Encode.varInt((long)identity.getPubkey().getExtraBytes(), (OutputStream)out);
        }
        this.data.write((OutputStream)out);
        Encode.varBytes((byte[])Singleton.security().getSignature(out.toByteArray(), identity.getPrivateKey()), (OutputStream)out);
        this.container = new CryptoBox(out.toByteArray(), publicKey);
    }

    public T decrypt(byte[] privateKey) throws IOException, DecryptionFailedException {
        SignatureCheckingInputStream in = new SignatureCheckingInputStream(this.container.decrypt(privateKey));
        long addressVersion = Decode.varInt((InputStream)in);
        long stream = Decode.varInt((InputStream)in);
        int behaviorBitfield = Decode.int32((InputStream)in);
        byte[] publicSigningKey = Decode.bytes((InputStream)in, (int)64);
        byte[] publicEncryptionKey = Decode.bytes((InputStream)in, (int)64);
        long nonceTrialsPerByte = addressVersion >= 3L ? Decode.varInt((InputStream)in) : 0L;
        long extraBytes = addressVersion >= 3L ? Decode.varInt((InputStream)in) : 0L;
        this.sender = new BitmessageAddress(Factory.createPubkey((long)addressVersion, (long)stream, (byte[])publicSigningKey, (byte[])publicEncryptionKey, (long)nonceTrialsPerByte, (long)extraBytes, (int)behaviorBitfield));
        this.data = (Streamable)this.dataReader.read(this.sender, in);
        in.checkSignature(this.sender.getPubkey());
        return this.data;
    }

    public void write(OutputStream out) throws IOException {
        Encode.varString((String)COMMAND, (OutputStream)out);
        this.container.write(out);
    }

    private class SignatureCheckingInputStream
    extends InputStream {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final InputStream wrapped;

        private SignatureCheckingInputStream(InputStream wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int read() throws IOException {
            int read = this.wrapped.read();
            if (read >= 0) {
                this.out.write(read);
            }
            return read;
        }

        public void checkSignature(Pubkey pubkey) throws IOException, RuntimeException {
            if (!Singleton.security().isSignatureValid(this.out.toByteArray(), Decode.varBytes((InputStream)this.wrapped), pubkey)) {
                throw new RuntimeException("Signature check failed");
            }
        }
    }

    public static interface Reader<T> {
        public T read(BitmessageAddress var1, InputStream var2) throws IOException;
    }
}

