/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.demo;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import java.util.List;
import java.util.Scanner;

public class CommandLine {
    public static final String COMMAND_BACK = "b) back";
    public static final String ERROR_UNKNOWN_COMMAND = "Unknown command. Please try again.";
    private Scanner scanner = new Scanner(System.in);

    public String nextCommand() {
        return this.scanner.nextLine().trim().toLowerCase();
    }

    public String nextLine() {
        return this.scanner.nextLine();
    }

    public String nextLineTrimmed() {
        return this.scanner.nextLine();
    }

    public boolean yesNo(String question) {
        String answer;
        do {
            System.out.println(question + " (y/n)");
            answer = this.scanner.nextLine();
            if (!"y".equalsIgnoreCase(answer)) continue;
            return true;
        } while (!"n".equalsIgnoreCase(answer));
        return false;
    }

    public BitmessageAddress selectAddress(List<BitmessageAddress> addresses, String label) {
        String command;
        if (addresses.size() == 1) {
            return addresses.get(0);
        }
        do {
            System.out.println();
            System.out.println(label);
            this.listAddresses(addresses, "contacts");
            System.out.println(COMMAND_BACK);
            switch (command = this.nextCommand()) {
                case "b": {
                    return null;
                }
            }
            try {
                int index = Integer.parseInt(command) - 1;
                if (addresses.get(index) != null) {
                    return addresses.get(index);
                }
            }
            catch (NumberFormatException e) {
                System.out.println(ERROR_UNKNOWN_COMMAND);
            }
        } while (!"b".equals(command));
        return null;
    }

    public void listAddresses(List<BitmessageAddress> addresses, String kind) {
        int i = 0;
        for (BitmessageAddress address : addresses) {
            System.out.print(++i + ") ");
            if (address.getAlias() == null) {
                System.out.println(address.getAddress());
                continue;
            }
            System.out.println(address.getAlias() + " (" + address.getAddress() + ")");
        }
        if (i == 0) {
            System.out.println("You have no " + kind + " yet.");
        }
    }
}

