/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.demo;

import ch.dissem.bitmessage.BitmessageContext;
import ch.dissem.bitmessage.demo.CommandLine;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.valueobject.Label;
import ch.dissem.bitmessage.ports.MessageRepository;
import java.net.InetAddress;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger LOG = LoggerFactory.getLogger(Application.class);
    private final CommandLine commandLine;
    private BitmessageContext ctx;

    public Application(BitmessageContext.Builder ctxBuilder, InetAddress syncServer, int syncPort) {
        String command;
        this.ctx = ctxBuilder.listener(plaintext -> System.out.println("New Message from " + plaintext.getFrom() + ": " + plaintext.getSubject())).build();
        if (syncServer == null) {
            this.ctx.startup();
        }
        this.commandLine = new CommandLine();
        block20: do {
            System.out.println();
            System.out.println("available commands:");
            System.out.println("i) identities");
            System.out.println("c) contacts");
            System.out.println("s) subscriptions");
            System.out.println("m) messages");
            if (syncServer != null) {
                System.out.println("y) sync");
            }
            System.out.println("?) info");
            System.out.println("e) exit");
            command = this.commandLine.nextCommand();
            try {
                switch (command) {
                    case "i": {
                        this.identities();
                        break;
                    }
                    case "c": {
                        this.contacts();
                        break;
                    }
                    case "s": {
                        this.subscriptions();
                        break;
                    }
                    case "m": {
                        this.labels();
                        break;
                    }
                    case "?": {
                        this.info();
                        break;
                    }
                    case "e": {
                        break;
                    }
                    case "y": {
                        if (syncServer == null) continue block20;
                        this.ctx.synchronize(syncServer, syncPort, 120L, true);
                        break;
                    }
                    default: {
                        System.out.println("Unknown command. Please try again.");
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        } while (!"e".equals(command));
        LOG.info("Shutting down client");
        this.ctx.cleanup();
        this.ctx.shutdown();
    }

    private void info() {
        String command;
        do {
            System.out.println();
            System.out.println(this.ctx.status());
            System.out.println();
            System.out.println("c) cleanup inventory");
            System.out.println("r) resend unacknowledged messages");
            System.out.println("b) back");
            switch (command = this.commandLine.nextCommand()) {
                case "c": {
                    this.ctx.cleanup();
                    break;
                }
                case "r": {
                    this.ctx.resendUnacknowledgedMessages();
                    break;
                }
                case "b": {
                    return;
                }
            }
        } while (!"b".equals(command));
    }

    private void identities() {
        String command;
        List identities = this.ctx.addresses().getIdentities();
        do {
            System.out.println();
            this.commandLine.listAddresses(identities, "identities");
            System.out.println("a) create identity");
            System.out.println("c) join chan");
            System.out.println("b) back");
            switch (command = this.commandLine.nextCommand()) {
                case "a": {
                    this.addIdentity();
                    identities = this.ctx.addresses().getIdentities();
                    break;
                }
                case "c": {
                    this.joinChan();
                    identities = this.ctx.addresses().getIdentities();
                    break;
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.address((BitmessageAddress)identities.get(index));
                        break;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equals(command));
    }

    private void addIdentity() {
        System.out.println();
        BitmessageAddress identity = this.ctx.createIdentity(this.commandLine.yesNo("would you like a shorter address? This will take some time to calculate."), new Pubkey.Feature[]{Pubkey.Feature.DOES_ACK});
        System.out.println("Please enter an alias for this identity, or an empty string for none");
        String alias = this.commandLine.nextLineTrimmed();
        if (alias.length() > 0) {
            identity.setAlias(alias);
        }
        this.ctx.addresses().save(identity);
    }

    private void joinChan() {
        System.out.println();
        System.out.print("Passphrase: ");
        String passphrase = this.commandLine.nextLine();
        System.out.print("Address: ");
        String address = this.commandLine.nextLineTrimmed();
        this.ctx.joinChan(passphrase, address);
    }

    private void contacts() {
        String command;
        List contacts = this.ctx.addresses().getContacts();
        do {
            System.out.println();
            this.commandLine.listAddresses(contacts, "contacts");
            System.out.println();
            System.out.println("a) add contact");
            System.out.println("b) back");
            switch (command = this.commandLine.nextCommand()) {
                case "a": {
                    this.addContact(false);
                    contacts = this.ctx.addresses().getContacts();
                    break;
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.address((BitmessageAddress)contacts.get(index));
                        break;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equals(command));
    }

    private void addContact(boolean isSubscription) {
        System.out.println();
        System.out.println("Please enter the Bitmessage address you want to add");
        try {
            BitmessageAddress address = new BitmessageAddress(this.commandLine.nextLineTrimmed());
            System.out.println("Please enter an alias for this address, or an empty string for none");
            String alias = this.commandLine.nextLineTrimmed();
            if (alias.length() > 0) {
                address.setAlias(alias);
            }
            if (isSubscription) {
                this.ctx.addSubscribtion(address);
            }
            this.ctx.addContact(address);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    private void subscriptions() {
        String command;
        List subscriptions = this.ctx.addresses().getSubscriptions();
        do {
            System.out.println();
            this.commandLine.listAddresses(subscriptions, "subscriptions");
            System.out.println();
            System.out.println("a) add subscription");
            System.out.println("b) back");
            switch (command = this.commandLine.nextCommand()) {
                case "a": {
                    this.addContact(true);
                    subscriptions = this.ctx.addresses().getSubscriptions();
                    break;
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.address((BitmessageAddress)subscriptions.get(index));
                        break;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equals(command));
    }

    private void address(BitmessageAddress address) {
        System.out.println();
        if (address.getAlias() != null) {
            System.out.println(address.getAlias());
        }
        System.out.println(address.getAddress());
        System.out.println("Stream:  " + address.getStream());
        System.out.println("Version: " + address.getVersion());
        if (address.getPrivateKey() == null) {
            if (address.getPubkey() == null) {
                System.out.println("Public key still missing");
            } else {
                System.out.println("Public key available");
            }
        } else if (address.isChan()) {
            System.out.println("Chan");
        } else {
            System.out.println("Identity");
        }
    }

    private void labels() {
        String command;
        List labels = this.ctx.messages().getLabels();
        do {
            System.out.println();
            int i = 0;
            for (Label label : labels) {
                System.out.print(++i + ") " + label);
                int unread = this.ctx.messages().countUnread(label);
                if (unread > 0) {
                    System.out.println(" [" + unread + "]");
                    continue;
                }
                System.out.println();
            }
            System.out.println("a) Archive");
            System.out.println();
            System.out.println("c) compose message");
            System.out.println("s) compose broadcast");
            System.out.println("b) back");
            command = this.commandLine.nextCommand();
            switch (command) {
                case "a": {
                    this.messages(null);
                    break;
                }
                case "c": {
                    this.compose(false);
                    break;
                }
                case "s": {
                    this.compose(true);
                    break;
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.messages((Label)labels.get(index));
                        break;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equalsIgnoreCase(command));
    }

    private void messages(Label label) {
        String command;
        do {
            List messages = this.ctx.messages().findMessages(label);
            System.out.println();
            int i = 0;
            for (Plaintext message : messages) {
                System.out.println(++i + (message.isUnread() ? ">" : ")") + " From: " + message.getFrom() + "; Subject: " + message.getSubject());
            }
            if (i == 0) {
                System.out.println("There are no messages.");
            }
            System.out.println();
            System.out.println("c) compose message");
            System.out.println("s) compose broadcast");
            if (label.getType() == Label.Type.TRASH) {
                System.out.println("e) empty trash");
            }
            System.out.println("b) back");
            command = this.commandLine.nextCommand();
            switch (command) {
                case "c": {
                    this.compose(false);
                    break;
                }
                case "s": {
                    this.compose(true);
                    break;
                }
                case "e": {
                    messages.forEach(arg_0 -> ((MessageRepository)this.ctx.messages()).remove(arg_0));
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.show((Plaintext)messages.get(index));
                        break;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equalsIgnoreCase(command));
    }

    private void show(Plaintext message) {
        String command;
        System.out.println();
        System.out.println("From:    " + message.getFrom());
        System.out.println("To:      " + message.getTo());
        System.out.println("Subject: " + message.getSubject());
        System.out.println();
        System.out.println(WordUtils.wrap((String)message.getText(), (int)120));
        System.out.println();
        System.out.println(message.getLabels().stream().map(Label::toString).collect(Collectors.joining(", ", "Labels: ", "")));
        System.out.println();
        this.ctx.labeler().markAsRead(message);
        this.ctx.messages().save(message);
        do {
            System.out.println("r) reply");
            System.out.println("d) delete");
            System.out.println("a) archive");
            System.out.println("b) back");
            switch (command = this.commandLine.nextCommand()) {
                case "r": {
                    this.compose(message.getTo(), message.getFrom(), "RE: " + message.getSubject());
                    break;
                }
                case "d": {
                    this.ctx.labeler().delete(message);
                    this.ctx.messages().save(message);
                    return;
                }
                case "a": {
                    this.ctx.labeler().archive(message);
                    this.ctx.messages().save(message);
                    return;
                }
                case "b": {
                    return;
                }
                default: {
                    System.out.println("Unknown command. Please try again.");
                }
            }
        } while (!"b".equalsIgnoreCase(command));
    }

    private void compose(boolean broadcast) {
        BitmessageAddress to;
        System.out.println();
        BitmessageAddress from = this.selectIdentity();
        if (from == null) {
            return;
        }
        BitmessageAddress bitmessageAddress = to = broadcast ? null : this.selectContact();
        if (!broadcast && to == null) {
            return;
        }
        this.compose(from, to, null);
    }

    private BitmessageAddress selectIdentity() {
        List addresses = this.ctx.addresses().getIdentities();
        while (addresses.size() == 0) {
            this.addIdentity();
            addresses = this.ctx.addresses().getIdentities();
        }
        return this.commandLine.selectAddress(addresses, "From:");
    }

    private BitmessageAddress selectContact() {
        List addresses = this.ctx.addresses().getContacts();
        while (addresses.size() == 0) {
            this.addContact(false);
            addresses = this.ctx.addresses().getContacts();
        }
        return this.commandLine.selectAddress(addresses, "To:");
    }

    private void compose(BitmessageAddress from, BitmessageAddress to, String subject) {
        String line;
        boolean broadcast = to == null;
        System.out.println();
        System.out.println("From:    " + from);
        if (!broadcast) {
            System.out.println("To:      " + to);
        }
        if (subject != null) {
            System.out.println("Subject: " + subject);
        } else {
            System.out.print("Subject: ");
            subject = this.commandLine.nextLineTrimmed();
        }
        System.out.println("Message:");
        StringBuilder message = new StringBuilder();
        do {
            line = this.commandLine.nextLine();
            message.append(line).append('\n');
        } while (line.length() > 0 || !this.commandLine.yesNo("Send message?"));
        if (broadcast) {
            this.ctx.broadcast(from, subject, message.toString());
        } else {
            this.ctx.send(from, to, subject, message.toString());
        }
    }
}

