/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.demo;

import ch.dissem.bitmessage.BitmessageContext;
import ch.dissem.bitmessage.cryptography.bc.BouncyCryptography;
import ch.dissem.bitmessage.demo.Application;
import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.networking.nio.NioNetworkHandler;
import ch.dissem.bitmessage.ports.AddressRepository;
import ch.dissem.bitmessage.ports.Cryptography;
import ch.dissem.bitmessage.ports.Inventory;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.ports.NodeRegistry;
import ch.dissem.bitmessage.ports.ProofOfWorkRepository;
import ch.dissem.bitmessage.repository.JdbcAddressRepository;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcInventory;
import ch.dissem.bitmessage.repository.JdbcMessageRepository;
import ch.dissem.bitmessage.repository.JdbcNodeRegistry;
import ch.dissem.bitmessage.repository.JdbcProofOfWorkRepository;
import ch.dissem.bitmessage.wif.WifExporter;
import ch.dissem.bitmessage.wif.WifImporter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws IOException {
        if (System.getProperty("org.slf4j.simpleLogger.defaultLogLevel") == null) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "ERROR");
        }
        if (System.getProperty("org.slf4j.simpleLogger.logFile") == null) {
            System.setProperty("org.slf4j.simpleLogger.logFile", "./jabit.log");
        }
        final CmdLineOptions options = new CmdLineOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            parser.printUsage((OutputStream)System.err);
        }
        JdbcConfig jdbcConfig = new JdbcConfig();
        BitmessageContext.Builder ctxBuilder = new BitmessageContext.Builder().addressRepo((AddressRepository)new JdbcAddressRepository(jdbcConfig)).inventory((Inventory)new JdbcInventory(jdbcConfig)).messageRepo((MessageRepository)new JdbcMessageRepository(jdbcConfig)).powRepo((ProofOfWorkRepository)new JdbcProofOfWorkRepository(jdbcConfig)).networkHandler((NetworkHandler)new NioNetworkHandler()).cryptography((Cryptography)new BouncyCryptography()).port(48444);
        if (options.localPort != null) {
            ctxBuilder.nodeRegistry(new NodeRegistry(){

                public List<NetworkAddress> getKnownAddresses(int limit, long ... streams) {
                    return Arrays.stream(streams).mapToObj(s -> new NetworkAddress.Builder().ipv4(127, 0, 0, 1).port(options.localPort.intValue()).stream(s).build()).collect(Collectors.toList());
                }

                public void offerAddresses(List<NetworkAddress> addresses) {
                    LOG.info("Local node registry ignored offered addresses: " + addresses);
                }
            });
        } else {
            ctxBuilder.nodeRegistry((NodeRegistry)new JdbcNodeRegistry(jdbcConfig));
        }
        if (options.exportWIF != null || options.importWIF != null) {
            BitmessageContext ctx = ctxBuilder.build();
            if (options.exportWIF != null) {
                new WifExporter(ctx).addAll().write(options.exportWIF);
            }
            if (options.importWIF != null) {
                new WifImporter(ctx, options.importWIF).importAll();
            }
        } else {
            InetAddress syncServer = options.syncServer == null ? null : InetAddress.getByName(options.syncServer);
            new Application(ctxBuilder, syncServer, options.syncPort);
        }
    }

    private static class CmdLineOptions {
        @Option(name="-local", usage="Connect to local Bitmessage client on given port, instead of the usual connections from node.txt")
        private Integer localPort;
        @Option(name="-import", usage="Import from keys.dat or other WIF file.")
        private File importWIF;
        @Option(name="-export", usage="Export to WIF file.")
        private File exportWIF;
        @Option(name="-syncServer", usage="Use manual synchronization with the given server instead of starting a full node.")
        private String syncServer;
        @Option(name="-syncPort", usage="Port to use for synchronisation")
        private int syncPort = 8444;

        private CmdLineOptions() {
        }
    }
}

