/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.demo;

import ch.dissem.bitmessage.BitmessageContext;
import ch.dissem.bitmessage.demo.Application;
import ch.dissem.bitmessage.networking.NetworkNode;
import ch.dissem.bitmessage.ports.AddressRepository;
import ch.dissem.bitmessage.ports.Inventory;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.ports.NodeRegistry;
import ch.dissem.bitmessage.repository.JdbcAddressRepository;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcInventory;
import ch.dissem.bitmessage.repository.JdbcMessageRepository;
import ch.dissem.bitmessage.repository.MemoryNodeRegistry;
import ch.dissem.bitmessage.wif.WifExporter;
import ch.dissem.bitmessage.wif.WifImporter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Main {
    public static void main(String[] args) throws IOException {
        if (System.getProperty("org.slf4j.simpleLogger.defaultLogLevel") == null) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "ERROR");
        }
        if (System.getProperty("org.slf4j.simpleLogger.logFile") == null) {
            System.setProperty("org.slf4j.simpleLogger.logFile", "./jabit.log");
        }
        CmdLineOptions options = new CmdLineOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            parser.printUsage((OutputStream)System.err);
        }
        if (options.exportWIF != null || options.importWIF != null) {
            JdbcConfig jdbcConfig = new JdbcConfig();
            BitmessageContext ctx = new BitmessageContext.Builder().addressRepo((AddressRepository)new JdbcAddressRepository(jdbcConfig)).inventory((Inventory)new JdbcInventory(jdbcConfig)).nodeRegistry((NodeRegistry)new MemoryNodeRegistry()).messageRepo((MessageRepository)new JdbcMessageRepository(jdbcConfig)).networkHandler((NetworkHandler)new NetworkNode()).port(48444).build();
            if (options.exportWIF != null) {
                new WifExporter(ctx).addAll().write(options.exportWIF);
            }
            if (options.importWIF != null) {
                new WifImporter(ctx, options.importWIF).importAll();
            }
        } else {
            new Application();
        }
    }

    private static class CmdLineOptions {
        @Option(name="-import", usage="Import from keys.dat or other WIF file.")
        private File importWIF;
        @Option(name="-export", usage="Export to WIF file.")
        private File exportWIF;

        private CmdLineOptions() {
        }
    }
}

