/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.demo;

import ch.dissem.bitmessage.BitmessageContext;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.networking.NetworkNode;
import ch.dissem.bitmessage.ports.AddressRepository;
import ch.dissem.bitmessage.ports.Inventory;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.ports.NetworkHandler;
import ch.dissem.bitmessage.ports.NodeRegistry;
import ch.dissem.bitmessage.repository.JdbcAddressRepository;
import ch.dissem.bitmessage.repository.JdbcConfig;
import ch.dissem.bitmessage.repository.JdbcInventory;
import ch.dissem.bitmessage.repository.JdbcMessageRepository;
import ch.dissem.bitmessage.repository.MemoryNodeRegistry;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger LOG = LoggerFactory.getLogger(Application.class);
    private final Scanner scanner;
    private BitmessageContext ctx;

    public Application() {
        String command;
        JdbcConfig jdbcConfig = new JdbcConfig();
        this.ctx = new BitmessageContext.Builder().addressRepo((AddressRepository)new JdbcAddressRepository(jdbcConfig)).inventory((Inventory)new JdbcInventory(jdbcConfig)).nodeRegistry((NodeRegistry)new MemoryNodeRegistry()).messageRepo((MessageRepository)new JdbcMessageRepository(jdbcConfig)).networkHandler((NetworkHandler)new NetworkNode()).port(48444).build();
        this.ctx.startup(new BitmessageContext.Listener(){

            public void receive(Plaintext plaintext) {
                try {
                    System.out.println(new String(plaintext.getMessage(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.scanner = new Scanner(System.in);
        do {
            System.out.println();
            System.out.println("available commands:");
            System.out.println("i) identities");
            System.out.println("c) contacts");
            System.out.println("s) subscriptions");
            System.out.println("m) messages");
            System.out.println("?) info");
            System.out.println("e) exit");
            command = this.nextCommand();
            try {
                switch (command) {
                    case "i": {
                        this.identities();
                        break;
                    }
                    case "c": {
                        this.contacts();
                        break;
                    }
                    case "s": {
                        this.subscriptions();
                        break;
                    }
                    case "m": {
                        this.messages();
                        break;
                    }
                    case "?": {
                        this.info();
                        break;
                    }
                    case "e": {
                        break;
                    }
                    default: {
                        System.out.println("Unknown command. Please try again.");
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOG.debug(e.getMessage());
            }
        } while (!"e".equals(command));
        LOG.info("Shutting down client");
        this.ctx.shutdown();
    }

    private void info() {
        System.out.println();
        System.out.println(this.ctx.status());
    }

    private String nextCommand() {
        return this.scanner.nextLine().trim().toLowerCase();
    }

    private void identities() {
        String command;
        List identities = this.ctx.addresses().getIdentities();
        do {
            System.out.println();
            int i = 0;
            for (BitmessageAddress identity : identities) {
                System.out.print(++i + ") ");
                if (identity.getAlias() != null) {
                    System.out.println(identity.getAlias() + " (" + identity.getAddress() + ")");
                    continue;
                }
                System.out.println(identity.getAddress());
            }
            if (i == 0) {
                System.out.println("You have no identities yet.");
            }
            System.out.println("a) create identity");
            System.out.println("b) back");
            command = this.nextCommand();
            switch (command) {
                case "a": {
                    this.addIdentity();
                    identities = this.ctx.addresses().getIdentities();
                    break;
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.address((BitmessageAddress)identities.get(index));
                        break;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equals(command));
    }

    private void addIdentity() {
        System.out.println();
        BitmessageAddress identity = this.ctx.createIdentity(this.yesNo("would you like a shorter address? This will take some time to calculate."), new Pubkey.Feature[]{Pubkey.Feature.DOES_ACK});
        System.out.println("Please enter an alias for this identity, or an empty string for none");
        String alias = this.scanner.nextLine().trim();
        if (alias.length() > 0) {
            identity.setAlias(alias);
        }
        this.ctx.addresses().save(identity);
    }

    private void contacts() {
        String command;
        List contacts = this.ctx.addresses().getContacts();
        do {
            System.out.println();
            int i = 0;
            for (BitmessageAddress contact : contacts) {
                System.out.print(++i + ") ");
                if (contact.getAlias() != null) {
                    System.out.println(contact.getAlias() + " (" + contact.getAddress() + ")");
                    continue;
                }
                System.out.println(contact.getAddress());
            }
            if (i == 0) {
                System.out.println("You have no contacts yet.");
            }
            System.out.println();
            System.out.println("a) add contact");
            System.out.println("b) back");
            command = this.nextCommand();
            switch (command) {
                case "a": {
                    this.addContact(false);
                    contacts = this.ctx.addresses().getContacts();
                    break;
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.address((BitmessageAddress)contacts.get(index));
                        break;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equals(command));
    }

    private void addContact(boolean isSubscription) {
        System.out.println();
        System.out.println("Please enter the Bitmessage address you want to add");
        try {
            BitmessageAddress address = new BitmessageAddress(this.scanner.nextLine().trim());
            System.out.println("Please enter an alias for this address, or an empty string for none");
            String alias = this.scanner.nextLine().trim();
            if (alias.length() > 0) {
                address.setAlias(alias);
            }
            if (isSubscription) {
                this.ctx.addSubscribtion(address);
            }
            this.ctx.addContact(address);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
    }

    private void subscriptions() {
        String command;
        List subscriptions = this.ctx.addresses().getSubscriptions();
        do {
            System.out.println();
            int i = 0;
            for (BitmessageAddress contact : subscriptions) {
                System.out.print(++i + ") ");
                if (contact.getAlias() != null) {
                    System.out.println(contact.getAlias() + " (" + contact.getAddress() + ")");
                    continue;
                }
                System.out.println(contact.getAddress());
            }
            if (i == 0) {
                System.out.println("You have no subscriptions yet.");
            }
            System.out.println();
            System.out.println("a) add subscription");
            System.out.println("b) back");
            command = this.nextCommand();
            switch (command) {
                case "a": {
                    this.addContact(true);
                    subscriptions = this.ctx.addresses().getSubscriptions();
                    break;
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.address((BitmessageAddress)subscriptions.get(index));
                        break;
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equals(command));
    }

    private void address(BitmessageAddress address) {
        System.out.println();
        if (address.getAlias() != null) {
            System.out.println(address.getAlias());
        }
        System.out.println(address.getAddress());
        System.out.println("Stream:  " + address.getStream());
        System.out.println("Version: " + address.getVersion());
        if (address.getPrivateKey() == null) {
            if (address.getPubkey() != null) {
                System.out.println("Public key available");
            } else {
                System.out.println("Public key still missing");
            }
        }
    }

    private void messages() {
        String command;
        List messages = this.ctx.messages().findMessages(Plaintext.Status.RECEIVED);
        do {
            System.out.println();
            int i = 0;
            for (Plaintext message : messages) {
                System.out.println(++i + ") From: " + message.getFrom() + "; Subject: " + message.getSubject());
            }
            if (i == 0) {
                System.out.println("You have no messages.");
            }
            System.out.println();
            System.out.println("c) compose message");
            System.out.println("s) compose broadcast");
            System.out.println("b) back");
            command = this.scanner.nextLine().trim();
            switch (command) {
                case "c": {
                    this.compose(false);
                    break;
                }
                case "s": {
                    this.compose(true);
                    break;
                }
                case "b": {
                    return;
                }
                default: {
                    try {
                        int index = Integer.parseInt(command) - 1;
                        this.show((Plaintext)messages.get(index));
                        break;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException e) {
                        System.out.println("Unknown command. Please try again.");
                    }
                }
            }
        } while (!"b".equalsIgnoreCase(command));
    }

    private void show(Plaintext message) {
        String command;
        System.out.println();
        System.out.println("From:    " + message.getFrom());
        System.out.println("To:      " + message.getTo());
        System.out.println("Subject: " + message.getSubject());
        System.out.println();
        System.out.println(message.getText());
        System.out.println();
        System.out.println("Labels: " + message.getLabels());
        System.out.println();
        do {
            System.out.println("r) reply");
            System.out.println("d) delete");
            System.out.println("b) back");
            switch (command = this.nextCommand()) {
                case "r": {
                    this.compose(message.getTo(), message.getFrom(), "RE: " + message.getSubject());
                    break;
                }
                case "d": {
                    this.ctx.messages().remove(message);
                }
                case "b": {
                    return;
                }
                default: {
                    System.out.println("Unknown command. Please try again.");
                }
            }
        } while (!"b".equalsIgnoreCase(command));
    }

    private void compose(boolean broadcast) {
        BitmessageAddress to;
        System.out.println();
        BitmessageAddress from = this.selectAddress(true);
        if (from == null) {
            return;
        }
        BitmessageAddress bitmessageAddress = to = broadcast ? null : this.selectAddress(false);
        if (!broadcast && to == null) {
            return;
        }
        this.compose(from, to, null);
    }

    private BitmessageAddress selectAddress(boolean id) {
        String command;
        List addresses;
        List list = addresses = id ? this.ctx.addresses().getIdentities() : this.ctx.addresses().getContacts();
        while (addresses.size() == 0) {
            if (id) {
                this.addIdentity();
                addresses = this.ctx.addresses().getIdentities();
                continue;
            }
            this.addContact(false);
            addresses = this.ctx.addresses().getContacts();
        }
        if (addresses.size() == 1) {
            return (BitmessageAddress)addresses.get(0);
        }
        do {
            System.out.println();
            if (id) {
                System.out.println("From:");
            } else {
                System.out.println("To:");
            }
            int i = 0;
            for (BitmessageAddress identity : addresses) {
                System.out.print(++i + ") ");
                if (identity.getAlias() != null) {
                    System.out.println(identity.getAlias() + " (" + identity.getAddress() + ")");
                    continue;
                }
                System.out.println(identity.getAddress());
            }
            System.out.println("b) back");
            command = this.nextCommand();
            switch (command) {
                case "b": {
                    return null;
                }
            }
            try {
                int index = Integer.parseInt(command) - 1;
                if (addresses.get(index) != null) {
                    return (BitmessageAddress)addresses.get(index);
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Unknown command. Please try again.");
            }
        } while (!"b".equals(command));
        return null;
    }

    private void compose(BitmessageAddress from, BitmessageAddress to, String subject) {
        String line;
        boolean broadcast = to == null;
        System.out.println();
        System.out.println("From:    " + from);
        if (!broadcast) {
            System.out.println("To:      " + to);
        }
        if (subject != null) {
            System.out.println("Subject: " + subject);
        } else {
            System.out.print("Subject: ");
            subject = this.scanner.nextLine().trim();
        }
        System.out.println("Message:");
        StringBuilder message = new StringBuilder();
        do {
            line = this.scanner.nextLine();
            message.append(line).append('\n');
        } while (line.length() > 0 || !this.yesNo("Send message?"));
        if (broadcast) {
            this.ctx.broadcast(from, subject, message.toString());
        } else {
            this.ctx.send(from, to, subject, message.toString());
        }
    }

    private boolean yesNo(String question) {
        String answer;
        do {
            System.out.println(question + " (y/n)");
            answer = this.scanner.nextLine();
            if (!"y".equalsIgnoreCase(answer)) continue;
            return true;
        } while (!"n".equalsIgnoreCase(answer));
        return false;
    }
}

