/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.cryptography.sc;

import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.ports.AbstractCryptography;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.spongycastle.asn1.x9.X9ECParameters;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.ec.CustomNamedCurves;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.modes.CBCBlockCipher;
import org.spongycastle.crypto.paddings.BlockCipherPadding;
import org.spongycastle.crypto.paddings.PKCS7Padding;
import org.spongycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;
import org.spongycastle.jce.provider.BouncyCastleProvider;
import org.spongycastle.jce.spec.ECParameterSpec;
import org.spongycastle.jce.spec.ECPrivateKeySpec;
import org.spongycastle.jce.spec.ECPublicKeySpec;
import org.spongycastle.math.ec.ECPoint;

public class SpongyCryptography
extends AbstractCryptography {
    private static final X9ECParameters EC_CURVE_PARAMETERS = CustomNamedCurves.getByName((String)"secp256k1");
    private static final String ALGORITHM_ECDSA = "ECDSA";
    private static final String PROVIDER = "SC";

    public SpongyCryptography() {
        super(PROVIDER);
    }

    public byte[] crypt(boolean encrypt, byte[] data, byte[] key_e, byte[] initializationVector) {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(key_e), initializationVector);
        cipher.init(encrypt, (CipherParameters)params);
        byte[] buffer = new byte[cipher.getOutputSize(data.length)];
        int length = cipher.processBytes(data, 0, data.length, buffer, 0);
        try {
            length += cipher.doFinal(buffer, length);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalArgumentException(e);
        }
        if (length < buffer.length) {
            return Arrays.copyOfRange(buffer, 0, length);
        }
        return buffer;
    }

    public byte[] createPublicKey(byte[] privateKey) {
        return EC_CURVE_PARAMETERS.getG().multiply(this.keyToBigInt(privateKey)).normalize().getEncoded(false);
    }

    private ECPoint keyToPoint(byte[] publicKey) {
        BigInteger x = new BigInteger(1, Arrays.copyOfRange(publicKey, 1, 33));
        BigInteger y = new BigInteger(1, Arrays.copyOfRange(publicKey, 33, 65));
        return EC_CURVE_PARAMETERS.getCurve().createPoint(x, y);
    }

    public boolean isSignatureValid(byte[] data, byte[] signature, Pubkey pubkey) {
        try {
            ECParameterSpec spec = new ECParameterSpec(EC_CURVE_PARAMETERS.getCurve(), EC_CURVE_PARAMETERS.getG(), EC_CURVE_PARAMETERS.getN(), EC_CURVE_PARAMETERS.getH(), EC_CURVE_PARAMETERS.getSeed());
            ECPoint Q = this.keyToPoint(pubkey.getSigningKey());
            ECPublicKeySpec keySpec = new ECPublicKeySpec(Q, spec);
            PublicKey publicKey = KeyFactory.getInstance(ALGORITHM_ECDSA, PROVIDER).generatePublic((KeySpec)keySpec);
            Signature sig = Signature.getInstance(ALGORITHM_ECDSA, PROVIDER);
            sig.initVerify(publicKey);
            sig.update(data);
            return sig.verify(signature);
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public byte[] getSignature(byte[] data, ch.dissem.bitmessage.entity.valueobject.PrivateKey privateKey) {
        try {
            ECParameterSpec spec = new ECParameterSpec(EC_CURVE_PARAMETERS.getCurve(), EC_CURVE_PARAMETERS.getG(), EC_CURVE_PARAMETERS.getN(), EC_CURVE_PARAMETERS.getH(), EC_CURVE_PARAMETERS.getSeed());
            BigInteger d = this.keyToBigInt(privateKey.getPrivateSigningKey());
            ECPrivateKeySpec keySpec = new ECPrivateKeySpec(d, spec);
            PrivateKey privKey = KeyFactory.getInstance(ALGORITHM_ECDSA, PROVIDER).generatePrivate((KeySpec)keySpec);
            Signature sig = Signature.getInstance(ALGORITHM_ECDSA, PROVIDER);
            sig.initSign(privKey);
            sig.update(data);
            return sig.sign();
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public byte[] multiply(byte[] K, byte[] r) {
        return this.keyToPoint(K).multiply(this.keyToBigInt(r)).normalize().getEncoded(false);
    }

    public byte[] createPoint(byte[] x, byte[] y) {
        return EC_CURVE_PARAMETERS.getCurve().createPoint(new BigInteger(1, x), new BigInteger(1, y)).getEncoded(false);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

