/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.cryptography.bc;

import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.ports.AbstractCryptography;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class BouncyCryptography
extends AbstractCryptography {
    private static final X9ECParameters EC_CURVE_PARAMETERS = CustomNamedCurves.getByName((String)"secp256k1");
    private static final String ALGORITHM_ECDSA = "ECDSA";

    public BouncyCryptography() {
        super((Provider)new BouncyCastleProvider());
    }

    public byte[] crypt(boolean encrypt, byte[] data, byte[] key_e, byte[] initializationVector) {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)new PKCS7Padding());
        ParametersWithIV params = new ParametersWithIV((CipherParameters)new KeyParameter(key_e), initializationVector);
        cipher.init(encrypt, (CipherParameters)params);
        byte[] buffer = new byte[cipher.getOutputSize(data.length)];
        int length = cipher.processBytes(data, 0, data.length, buffer, 0);
        try {
            length += cipher.doFinal(buffer, length);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalArgumentException(e);
        }
        if (length < buffer.length) {
            return Arrays.copyOfRange(buffer, 0, length);
        }
        return buffer;
    }

    public byte[] createPublicKey(byte[] privateKey) {
        return EC_CURVE_PARAMETERS.getG().multiply(this.keyToBigInt(privateKey)).normalize().getEncoded(false);
    }

    private ECPoint keyToPoint(byte[] publicKey) {
        BigInteger x = new BigInteger(1, Arrays.copyOfRange(publicKey, 1, 33));
        BigInteger y = new BigInteger(1, Arrays.copyOfRange(publicKey, 33, 65));
        return EC_CURVE_PARAMETERS.getCurve().createPoint(x, y);
    }

    public boolean isSignatureValid(byte[] data, byte[] signature, Pubkey pubkey) {
        try {
            ECParameterSpec spec = new ECParameterSpec(EC_CURVE_PARAMETERS.getCurve(), EC_CURVE_PARAMETERS.getG(), EC_CURVE_PARAMETERS.getN(), EC_CURVE_PARAMETERS.getH(), EC_CURVE_PARAMETERS.getSeed());
            ECPoint Q = this.keyToPoint(pubkey.getSigningKey());
            ECPublicKeySpec keySpec = new ECPublicKeySpec(Q, spec);
            PublicKey publicKey = KeyFactory.getInstance(ALGORITHM_ECDSA, this.provider).generatePublic((KeySpec)keySpec);
            Signature sig = Signature.getInstance(ALGORITHM_ECDSA, this.provider);
            sig.initVerify(publicKey);
            sig.update(data);
            return sig.verify(signature);
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public byte[] getSignature(byte[] data, ch.dissem.bitmessage.entity.valueobject.PrivateKey privateKey) {
        try {
            ECParameterSpec spec = new ECParameterSpec(EC_CURVE_PARAMETERS.getCurve(), EC_CURVE_PARAMETERS.getG(), EC_CURVE_PARAMETERS.getN(), EC_CURVE_PARAMETERS.getH(), EC_CURVE_PARAMETERS.getSeed());
            BigInteger d = this.keyToBigInt(privateKey.getPrivateSigningKey());
            ECPrivateKeySpec keySpec = new ECPrivateKeySpec(d, spec);
            PrivateKey privKey = KeyFactory.getInstance(ALGORITHM_ECDSA, this.provider).generatePrivate((KeySpec)keySpec);
            Signature sig = Signature.getInstance(ALGORITHM_ECDSA, this.provider);
            sig.initSign(privKey);
            sig.update(data);
            return sig.sign();
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    public byte[] multiply(byte[] K, byte[] r) {
        return this.keyToPoint(K).multiply(this.keyToBigInt(r)).normalize().getEncoded(false);
    }

    public byte[] createPoint(byte[] x, byte[] y) {
        return EC_CURVE_PARAMETERS.getCurve().createPoint(new BigInteger(1, x), new BigInteger(1, y)).getEncoded(false);
    }
}

