/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.utils;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactoryBuilder {
    private final String namePrefix;
    private int prio = 5;
    private boolean daemon = false;

    private ThreadFactoryBuilder(String pool) {
        this.namePrefix = pool + "-thread-";
    }

    public static ThreadFactoryBuilder pool(String name) {
        return new ThreadFactoryBuilder(name);
    }

    public ThreadFactoryBuilder lowPrio() {
        this.prio = 1;
        return this;
    }

    public ThreadFactoryBuilder daemon() {
        this.daemon = true;
        return this;
    }

    public ThreadFactory build() {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(group, r, ThreadFactoryBuilder.this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
                t.setPriority(ThreadFactoryBuilder.this.prio);
                t.setDaemon(ThreadFactoryBuilder.this.daemon);
                return t;
            }
        };
    }
}

