/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.utils;

import java.util.Arrays;
import java.util.Objects;

public class Property {
    private String name;
    private Object value;
    private Property[] properties;

    public Property(String name, Object value, Property ... properties) {
        this.name = name;
        this.value = value;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Property getProperty(String ... name) {
        if (name == null || name.length == 0) {
            return null;
        }
        for (Property p : this.properties) {
            if (!Objects.equals(name[0], p.name)) continue;
            if (name.length == 1) {
                return p;
            }
            return p.getProperty(Arrays.copyOfRange(name, 1, name.length));
        }
        return null;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String indentation) {
        StringBuilder result = new StringBuilder();
        result.append(indentation).append(this.name).append(": ");
        if (this.value != null || this.properties.length == 0) {
            result.append(this.value);
        }
        if (this.properties.length > 0) {
            result.append("{\n");
            for (Property property : this.properties) {
                result.append(property.toString(indentation + "  ")).append('\n');
            }
            result.append(indentation).append("}");
        }
        return result.toString();
    }
}

