/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.utils;

import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.utils.AccessCounter;
import ch.dissem.bitmessage.utils.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class Encode {
    public static void varIntList(long[] values, OutputStream stream) throws IOException {
        Encode.varInt((long)values.length, stream);
        for (long value : values) {
            Encode.varInt(value, stream);
        }
    }

    public static void varIntList(long[] values, ByteBuffer buffer) {
        Encode.varInt((long)values.length, buffer);
        for (long value : values) {
            Encode.varInt(value, buffer);
        }
    }

    public static void varInt(long value, OutputStream stream) throws IOException {
        Encode.varInt(value, stream, null);
    }

    public static void varInt(long value, ByteBuffer buffer) {
        if (value < 0L) {
            buffer.put((byte)-1);
            buffer.putLong(value);
        } else if (value < 253L) {
            buffer.put((byte)value);
        } else if (value <= 65535L) {
            buffer.put((byte)-3);
            buffer.putShort((short)value);
        } else if (value <= 0xFFFFFFFFL) {
            buffer.put((byte)-2);
            buffer.putInt((int)value);
        } else {
            buffer.put((byte)-1);
            buffer.putLong(value);
        }
    }

    public static byte[] varInt(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        Encode.varInt(value, buffer);
        buffer.flip();
        return Bytes.truncate(buffer.array(), buffer.limit());
    }

    public static void varInt(long value, OutputStream stream, AccessCounter counter) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        Encode.varInt(value, buffer);
        buffer.flip();
        stream.write(buffer.array(), 0, buffer.limit());
        AccessCounter.inc(counter, buffer.limit());
    }

    public static void int8(long value, OutputStream stream) throws IOException {
        Encode.int8(value, stream, null);
    }

    public static void int8(long value, OutputStream stream, AccessCounter counter) throws IOException {
        stream.write((int)value);
        AccessCounter.inc(counter);
    }

    public static void int16(long value, OutputStream stream) throws IOException {
        Encode.int16(value, stream, null);
    }

    public static void int16(long value, OutputStream stream, AccessCounter counter) throws IOException {
        stream.write(ByteBuffer.allocate(2).putShort((short)value).array());
        AccessCounter.inc(counter, 2);
    }

    public static void int16(long value, ByteBuffer buffer) {
        buffer.putShort((short)value);
    }

    public static void int32(long value, OutputStream stream) throws IOException {
        Encode.int32(value, stream, null);
    }

    public static void int32(long value, OutputStream stream, AccessCounter counter) throws IOException {
        stream.write(ByteBuffer.allocate(4).putInt((int)value).array());
        AccessCounter.inc(counter, 4);
    }

    public static void int32(long value, ByteBuffer buffer) {
        buffer.putInt((int)value);
    }

    public static void int64(long value, OutputStream stream) throws IOException {
        Encode.int64(value, stream, null);
    }

    public static void int64(long value, OutputStream stream, AccessCounter counter) throws IOException {
        stream.write(ByteBuffer.allocate(8).putLong(value).array());
        AccessCounter.inc(counter, 8);
    }

    public static void int64(long value, ByteBuffer buffer) {
        buffer.putLong(value);
    }

    public static void varString(String value, OutputStream out) throws IOException {
        byte[] bytes = value.getBytes("utf-8");
        Encode.varInt((long)bytes.length, out);
        out.write(bytes);
    }

    public static void varString(String value, ByteBuffer buffer) {
        try {
            byte[] bytes = value.getBytes("utf-8");
            buffer.put(Encode.varInt(bytes.length));
            buffer.put(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e);
        }
    }

    public static void varBytes(byte[] data, OutputStream out) throws IOException {
        Encode.varInt((long)data.length, out);
        out.write(data);
    }

    public static void varBytes(byte[] data, ByteBuffer buffer) {
        Encode.varInt((long)data.length, buffer);
        buffer.put(data);
    }

    public static byte[] bytes(Streamable streamable) {
        if (streamable == null) {
            return null;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            streamable.write(stream);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
        return stream.toByteArray();
    }

    public static byte[] bytes(Streamable streamable, int padding) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            streamable.write(stream);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
        int offset = padding - stream.size() % padding;
        int length = stream.size() + offset;
        byte[] result = new byte[length];
        stream.write(result, offset, stream.size());
        return result;
    }
}

