/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.utils;

import ch.dissem.bitmessage.utils.AccessCounter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Decode {
    public static byte[] shortVarBytes(InputStream in, AccessCounter counter) throws IOException {
        int length = Decode.uint16(in, counter);
        return Decode.bytes(in, length, counter);
    }

    public static byte[] varBytes(InputStream in) throws IOException {
        return Decode.varBytes(in, null);
    }

    public static byte[] varBytes(InputStream in, AccessCounter counter) throws IOException {
        int length = (int)Decode.varInt(in, counter);
        return Decode.bytes(in, length, counter);
    }

    public static byte[] bytes(InputStream in, int count) throws IOException {
        return Decode.bytes(in, count, null);
    }

    public static byte[] bytes(InputStream in, int count, AccessCounter counter) throws IOException {
        int read;
        byte[] result = new byte[count];
        for (int off = 0; off < count; off += read) {
            read = in.read(result, off, count - off);
            if (read >= 0) continue;
            throw new IOException("Unexpected end of stream, wanted to read " + count + " bytes but only got " + off);
        }
        AccessCounter.inc(counter, count);
        return result;
    }

    public static long[] varIntList(InputStream in) throws IOException {
        int length = (int)Decode.varInt(in);
        long[] result = new long[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Decode.varInt(in);
        }
        return result;
    }

    public static long varInt(InputStream in) throws IOException {
        return Decode.varInt(in, null);
    }

    public static long varInt(InputStream in, AccessCounter counter) throws IOException {
        int first = in.read();
        AccessCounter.inc(counter);
        switch (first) {
            case 253: {
                return Decode.uint16(in, counter);
            }
            case 254: {
                return Decode.uint32(in, counter);
            }
            case 255: {
                return Decode.int64(in, counter);
            }
        }
        return first;
    }

    public static int uint8(InputStream in) throws IOException {
        return in.read();
    }

    public static int uint16(InputStream in) throws IOException {
        return Decode.uint16(in, null);
    }

    public static int uint16(InputStream in, AccessCounter counter) throws IOException {
        AccessCounter.inc(counter, 2);
        return in.read() << 8 | in.read();
    }

    public static long uint32(InputStream in) throws IOException {
        return Decode.uint32(in, null);
    }

    public static long uint32(InputStream in, AccessCounter counter) throws IOException {
        AccessCounter.inc(counter, 4);
        return in.read() << 24 | in.read() << 16 | in.read() << 8 | in.read();
    }

    public static long uint32(ByteBuffer in) {
        return Decode.u(in.get()) << 24 | Decode.u(in.get()) << 16 | Decode.u(in.get()) << 8 | Decode.u(in.get());
    }

    public static int int32(InputStream in) throws IOException {
        return Decode.int32(in, null);
    }

    public static int int32(InputStream in, AccessCounter counter) throws IOException {
        AccessCounter.inc(counter, 4);
        return ByteBuffer.wrap(Decode.bytes(in, 4)).getInt();
    }

    public static long int64(InputStream in) throws IOException {
        return Decode.int64(in, null);
    }

    public static long int64(InputStream in, AccessCounter counter) throws IOException {
        AccessCounter.inc(counter, 8);
        return ByteBuffer.wrap(Decode.bytes(in, 8)).getLong();
    }

    public static String varString(InputStream in) throws IOException {
        return Decode.varString(in, null);
    }

    public static String varString(InputStream in, AccessCounter counter) throws IOException {
        int length = (int)Decode.varInt(in, counter);
        return new String(Decode.bytes(in, length, counter), "utf-8");
    }

    private static int u(byte b) {
        return b & 0xFF;
    }
}

