/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class Collections {
    private static final Random RANDOM = new Random();

    public static <T> List<T> selectRandom(int count, Collection<T> collection) {
        ArrayList<T> result = new ArrayList<T>(count);
        if (collection.size() <= count) {
            result.addAll(collection);
        } else {
            double collectionRest = collection.size();
            double resultRest = count;
            int skipMax = (int)Math.ceil(collectionRest / resultRest);
            int skip = RANDOM.nextInt(skipMax);
            for (T item : collection) {
                collectionRest -= 1.0;
                if (skip > 0) {
                    --skip;
                    continue;
                }
                result.add(item);
                if ((resultRest -= 1.0) == 0.0) break;
                skipMax = (int)Math.ceil(collectionRest / resultRest);
                skip = RANDOM.nextInt(skipMax);
            }
        }
        return result;
    }

    public static <T> T selectRandom(Collection<T> collection) {
        int index = RANDOM.nextInt(collection.size());
        for (T item : collection) {
            if (index == 0) {
                return item;
            }
            --index;
        }
        throw new IllegalArgumentException("Empty collection? Size: " + collection.size());
    }
}

