/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.utils;

public class Bytes {
    public static final byte BYTE_0x80 = -128;

    public static void inc(byte[] nonce) {
        for (int i = nonce.length - 1; i >= 0; --i) {
            int n = i;
            nonce[n] = (byte)(nonce[n] + 1);
            if (nonce[i] != 0) break;
        }
    }

    public static void inc(byte[] nonce, byte value) {
        int i;
        int n = i = nonce.length - 1;
        nonce[n] = (byte)(nonce[n] + value);
        if (value > 0 && (nonce[i] < 0 || nonce[i] >= value)) {
            return;
        }
        if (value < 0 && nonce[i] < 0 && nonce[i] >= value) {
            return;
        }
        --i;
        while (i >= 0) {
            int n2 = i;
            nonce[n2] = (byte)(nonce[n2] + 1);
            if (nonce[i] != 0) break;
            --i;
        }
    }

    public static boolean lt(byte[] a, byte[] b) {
        int i;
        byte[] max = a.length > b.length ? a : b;
        byte[] min = max == a ? b : a;
        int diff = max.length - min.length;
        for (i = 0; i < max.length - min.length; ++i) {
            if (max[i] == 0) continue;
            return a != max;
        }
        for (i = diff; i < max.length; ++i) {
            if (max[i] == min[i - diff]) continue;
            return Bytes.lt(max[i], min[i - diff]) == (a == max);
        }
        return false;
    }

    public static boolean lt(byte[] a, byte[] b, int size) {
        for (int i = 0; i < size; ++i) {
            if (a[i] == b[i]) continue;
            return Bytes.lt(a[i], b[i]);
        }
        return false;
    }

    private static boolean lt(byte a, byte b) {
        return (a ^ 0xFFFFFF80) < (b ^ 0xFFFFFF80);
    }

    public static byte[] expand(byte[] source, int size) {
        byte[] result = new byte[size];
        System.arraycopy(source, 0, result, size - source.length, source.length);
        return result;
    }

    public static byte[] truncate(byte[] source, int size) {
        byte[] result = new byte[size];
        System.arraycopy(source, 0, result, 0, size);
        return result;
    }

    public static byte[] fromHex(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("expected even number of characters");
        }
        byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)(Bytes.hexValue(hex.charAt(i * 2)) * 16);
            int n = i;
            result[n] = (byte)(result[n] + Bytes.hexValue(hex.charAt(i * 2 + 1)));
        }
        return result;
    }

    private static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        throw new IllegalArgumentException("'" + c + "' is not a valid hex value");
    }

    public static int numberOfLeadingZeros(byte[] bytes) {
        int i;
        for (i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 0) continue;
            return i;
        }
        return i;
    }
}

