/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.ports;

import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.ports.ProofOfWorkEngine;
import ch.dissem.bitmessage.utils.Bytes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SimplePOWEngine
implements ProofOfWorkEngine {
    @Override
    public void calculateNonce(byte[] initialHash, byte[] target, ProofOfWorkEngine.Callback callback) {
        try {
            MessageDigest mda = MessageDigest.getInstance("SHA-512");
            byte[] nonce = new byte[8];
            do {
                Bytes.inc(nonce);
                mda.update(nonce);
                mda.update(initialHash);
            } while (Bytes.lt(target, mda.digest(mda.digest()), 8));
            callback.onNonceCalculated(initialHash, nonce);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApplicationException(e);
        }
    }
}

