/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.ports;

import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.exception.ApplicationException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRegistryHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NodeRegistryHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Long, Set<NetworkAddress>> loadStableNodes() {
        try (InputStream in = NodeRegistryHelper.class.getClassLoader().getResourceAsStream("nodes.txt");){
            Scanner scanner = new Scanner(in);
            long stream = 0L;
            HashMap result = new HashMap();
            HashSet<NetworkAddress> streamSet = null;
            while (scanner.hasNext()) {
                try {
                    String line = scanner.nextLine().trim();
                    if (line.startsWith("[stream")) {
                        stream = Long.parseLong(line.substring(8, line.lastIndexOf(93)));
                        streamSet = new HashSet<NetworkAddress>();
                        result.put(stream, streamSet);
                        continue;
                    }
                    if (streamSet == null || line.isEmpty() || line.startsWith("#")) continue;
                    int n = line.lastIndexOf(58);
                    InetAddress[] inetAddresses = InetAddress.getAllByName(line.substring(0, n));
                    int port = Integer.valueOf(line.substring(n + 1));
                    for (InetAddress inetAddress : inetAddresses) {
                        streamSet.add(new NetworkAddress.Builder().ip(inetAddress).port(port).stream(stream).build());
                    }
                }
                catch (IOException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                for (Map.Entry entry : result.entrySet()) {
                    LOG.debug("Stream " + entry.getKey() + ": loaded " + ((Set)entry.getValue()).size() + " bootstrap nodes.");
                }
            }
            HashMap hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }
}

