/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.ports;

import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.ports.ProofOfWorkEngine;
import ch.dissem.bitmessage.utils.Bytes;
import ch.dissem.bitmessage.utils.ThreadFactoryBuilder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiThreadedPOWEngine
implements ProofOfWorkEngine {
    private static final Logger LOG = LoggerFactory.getLogger(MultiThreadedPOWEngine.class);
    private final ExecutorService waiterPool = Executors.newSingleThreadExecutor(ThreadFactoryBuilder.pool("POW-waiter").daemon().build());
    private final ExecutorService workerPool = Executors.newCachedThreadPool(ThreadFactoryBuilder.pool("POW-worker").daemon().build());

    @Override
    public void calculateNonce(final byte[] initialHash, final byte[] target, final ProofOfWorkEngine.Callback callback) {
        this.waiterPool.execute(new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                int cores = Runtime.getRuntime().availableProcessors();
                if (cores > 255) {
                    cores = 255;
                }
                LOG.info("Doing POW using " + cores + " cores");
                ArrayList workers = new ArrayList(cores);
                for (int i = 0; i < cores; ++i) {
                    Iterator w = new Worker((byte)cores, i, initialHash, target);
                    workers.add(w);
                }
                ArrayList<Future<byte[]>> futures = new ArrayList<Future<byte[]>>(cores);
                for (Worker worker : workers) {
                    futures.add(MultiThreadedPOWEngine.this.workerPool.submit(worker));
                }
                try {
                    while (!Thread.interrupted()) {
                        for (Future future : futures) {
                            if (!future.isDone()) continue;
                            callback.onNonceCalculated(initialHash, (byte[])future.get());
                            LOG.info("Nonce calculated in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
                            for (Future future2 : futures) {
                                future2.cancel(true);
                            }
                            return;
                        }
                        Thread.sleep(100L);
                    }
                    LOG.error("POW waiter thread interrupted - this should not happen!");
                }
                catch (ExecutionException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.error("POW waiter thread interrupted - this should not happen!", (Throwable)e);
                }
            }
        });
    }

    private class Worker
    implements Callable<byte[]> {
        private final byte numberOfCores;
        private final byte[] initialHash;
        private final byte[] target;
        private final MessageDigest mda;
        private final byte[] nonce = new byte[8];

        Worker(byte numberOfCores, int core, byte[] initialHash, byte[] target) {
            this.numberOfCores = numberOfCores;
            this.initialHash = initialHash;
            this.target = target;
            this.nonce[7] = (byte)core;
            try {
                this.mda = MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ApplicationException(e);
            }
        }

        @Override
        public byte[] call() throws Exception {
            do {
                Bytes.inc(this.nonce, this.numberOfCores);
                this.mda.update(this.nonce);
                this.mda.update(this.initialHash);
                if (Bytes.lt(this.target, this.mda.digest(this.mda.digest()), 8)) continue;
                return this.nonce;
            } while (!Thread.interrupted());
            return null;
        }
    }
}

