/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.ports;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.valueobject.Label;
import ch.dissem.bitmessage.ports.Labeler;

public class DefaultLabeler
implements Labeler,
InternalContext.ContextHolder {
    private InternalContext ctx;

    @Override
    public void setLabels(Plaintext msg) {
        msg.setStatus(Plaintext.Status.RECEIVED);
        if (msg.getType() == Plaintext.Type.BROADCAST) {
            msg.addLabels(this.ctx.getMessageRepository().getLabels(Label.Type.INBOX, Label.Type.BROADCAST, Label.Type.UNREAD));
        } else {
            msg.addLabels(this.ctx.getMessageRepository().getLabels(Label.Type.INBOX, Label.Type.UNREAD));
        }
    }

    @Override
    public void markAsDraft(Plaintext msg) {
        msg.setStatus(Plaintext.Status.DRAFT);
        msg.addLabels(this.ctx.getMessageRepository().getLabels(Label.Type.DRAFT));
    }

    @Override
    public void markAsSending(Plaintext msg) {
        if (msg.getTo() != null && msg.getTo().getPubkey() == null) {
            msg.setStatus(Plaintext.Status.PUBKEY_REQUESTED);
        } else {
            msg.setStatus(Plaintext.Status.DOING_PROOF_OF_WORK);
        }
        msg.removeLabel(Label.Type.DRAFT);
        msg.addLabels(this.ctx.getMessageRepository().getLabels(Label.Type.OUTBOX));
    }

    @Override
    public void markAsSent(Plaintext msg) {
        msg.setStatus(Plaintext.Status.SENT);
        msg.removeLabel(Label.Type.OUTBOX);
        msg.addLabels(this.ctx.getMessageRepository().getLabels(Label.Type.SENT));
    }

    @Override
    public void markAsAcknowledged(Plaintext msg) {
        msg.setStatus(Plaintext.Status.SENT_ACKNOWLEDGED);
    }

    @Override
    public void markAsRead(Plaintext msg) {
        msg.removeLabel(Label.Type.UNREAD);
    }

    @Override
    public void markAsUnread(Plaintext msg) {
        msg.addLabels(this.ctx.getMessageRepository().getLabels(Label.Type.UNREAD));
    }

    @Override
    public void delete(Plaintext msg) {
        msg.getLabels().clear();
        msg.addLabels(this.ctx.getMessageRepository().getLabels(Label.Type.TRASH));
    }

    @Override
    public void archive(Plaintext msg) {
        msg.getLabels().clear();
    }

    @Override
    public void setContext(InternalContext ctx) {
        this.ctx = ctx;
    }
}

