/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.ports;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.valueobject.Label;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.ports.MessageRepository;
import ch.dissem.bitmessage.utils.SqlStrings;
import ch.dissem.bitmessage.utils.Strings;
import ch.dissem.bitmessage.utils.UnixTime;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMessageRepository
implements MessageRepository,
InternalContext.ContextHolder {
    protected InternalContext ctx;

    @Override
    public void setContext(InternalContext context) {
        this.ctx = context;
    }

    protected void safeSenderIfNecessary(Plaintext message) {
        if (message.getId() == null) {
            BitmessageAddress savedAddress = this.ctx.getAddressRepository().getAddress(message.getFrom().getAddress());
            if (savedAddress == null) {
                this.ctx.getAddressRepository().save(message.getFrom());
            } else if (savedAddress.getPubkey() == null && message.getFrom().getPubkey() != null) {
                savedAddress.setPubkey(message.getFrom().getPubkey());
                this.ctx.getAddressRepository().save(savedAddress);
            }
        }
    }

    @Override
    public Plaintext getMessage(Object id) {
        if (id instanceof Long) {
            return this.single(this.find("id=" + id));
        }
        throw new IllegalArgumentException("Long expected for ID");
    }

    @Override
    public Plaintext getMessage(byte[] initialHash) {
        return this.single(this.find("initial_hash=X'" + Strings.hex(initialHash) + "'"));
    }

    @Override
    public Plaintext getMessageForAck(byte[] ackData) {
        return this.single(this.find("ack_data=X'" + Strings.hex(ackData) + "' AND status='" + (Object)((Object)Plaintext.Status.SENT) + "'"));
    }

    @Override
    public List<Plaintext> findMessages(Label label) {
        if (label == null) {
            return this.find("id NOT IN (SELECT message_id FROM Message_Label)");
        }
        return this.find("id IN (SELECT message_id FROM Message_Label WHERE label_id=" + label.getId() + ")");
    }

    @Override
    public List<Plaintext> findMessages(Plaintext.Status status, BitmessageAddress recipient) {
        return this.find("status='" + status.name() + "' AND recipient='" + recipient.getAddress() + "'");
    }

    @Override
    public List<Plaintext> findMessages(Plaintext.Status status) {
        return this.find("status='" + status.name() + "'");
    }

    @Override
    public List<Plaintext> findMessages(BitmessageAddress sender) {
        return this.find("sender='" + sender.getAddress() + "'");
    }

    @Override
    public List<Plaintext> findMessagesToResend() {
        return this.find("status='" + Plaintext.Status.SENT.name() + "'" + " AND next_try < " + UnixTime.now());
    }

    @Override
    public List<Label> getLabels() {
        return this.findLabels("1=1");
    }

    @Override
    public List<Label> getLabels(Label.Type ... types) {
        return this.findLabels("type IN (" + SqlStrings.join(types) + ")");
    }

    protected abstract List<Label> findLabels(String var1);

    protected <T> T single(Collection<T> collection) {
        switch (collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return collection.iterator().next();
            }
        }
        throw new ApplicationException("This shouldn't happen, found " + collection.size() + " items, one or none was expected");
    }

    protected abstract List<Plaintext> find(String var1);
}

