/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.ports;

import ch.dissem.bitmessage.InternalContext;
import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.exception.InsufficientProofOfWorkException;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.ports.Cryptography;
import ch.dissem.bitmessage.ports.ProofOfWorkEngine;
import ch.dissem.bitmessage.utils.Bytes;
import ch.dissem.bitmessage.utils.Numbers;
import ch.dissem.bitmessage.utils.UnixTime;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCryptography
implements Cryptography,
InternalContext.ContextHolder {
    protected static final Logger LOG = LoggerFactory.getLogger(Cryptography.class);
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger TWO_POW_64 = TWO.pow(64);
    private static final BigInteger TWO_POW_16 = TWO.pow(16);
    private final String provider;
    private InternalContext context;

    protected AbstractCryptography(String provider) {
        this.provider = provider;
    }

    @Override
    public void setContext(InternalContext context) {
        this.context = context;
    }

    @Override
    public byte[] sha512(byte[] data, int offset, int length) {
        MessageDigest mda = this.md("SHA-512");
        mda.update(data, offset, length);
        return mda.digest();
    }

    @Override
    public byte[] sha512(byte[] ... data) {
        return this.hash("SHA-512", data);
    }

    @Override
    public byte[] doubleSha512(byte[] ... data) {
        MessageDigest mda = this.md("SHA-512");
        for (byte[] d : data) {
            mda.update(d);
        }
        return mda.digest(mda.digest());
    }

    @Override
    public byte[] doubleSha512(byte[] data, int length) {
        MessageDigest mda = this.md("SHA-512");
        mda.update(data, 0, length);
        return mda.digest(mda.digest());
    }

    @Override
    public byte[] ripemd160(byte[] ... data) {
        return this.hash("RIPEMD160", data);
    }

    @Override
    public byte[] doubleSha256(byte[] data, int length) {
        MessageDigest mda = this.md("SHA-256");
        mda.update(data, 0, length);
        return mda.digest(mda.digest());
    }

    @Override
    public byte[] sha1(byte[] ... data) {
        return this.hash("SHA-1", data);
    }

    @Override
    public byte[] randomBytes(int length) {
        byte[] result = new byte[length];
        RANDOM.nextBytes(result);
        return result;
    }

    @Override
    public void doProofOfWork(ObjectMessage object, long nonceTrialsPerByte, long extraBytes, ProofOfWorkEngine.Callback callback) {
        nonceTrialsPerByte = Numbers.max(nonceTrialsPerByte, 1000L);
        extraBytes = Numbers.max(extraBytes, 1000L);
        byte[] initialHash = this.getInitialHash(object);
        byte[] target = this.getProofOfWorkTarget(object, nonceTrialsPerByte, extraBytes);
        this.context.getProofOfWorkEngine().calculateNonce(initialHash, target, callback);
    }

    @Override
    public void checkProofOfWork(ObjectMessage object, long nonceTrialsPerByte, long extraBytes) throws IOException {
        byte[] target = this.getProofOfWorkTarget(object, nonceTrialsPerByte, extraBytes);
        byte[] value = this.doubleSha512(object.getNonce(), this.getInitialHash(object));
        if (Bytes.lt(target, value, 8)) {
            throw new InsufficientProofOfWorkException(target, value);
        }
    }

    @Override
    public byte[] getInitialHash(ObjectMessage object) {
        return this.sha512(new byte[][]{object.getPayloadBytesWithoutNonce()});
    }

    @Override
    public byte[] getProofOfWorkTarget(ObjectMessage object, long nonceTrialsPerByte, long extraBytes) {
        if (nonceTrialsPerByte == 0L) {
            nonceTrialsPerByte = 1000L;
        }
        if (extraBytes == 0L) {
            extraBytes = 1000L;
        }
        BigInteger TTL2 = BigInteger.valueOf(object.getExpiresTime() - UnixTime.now());
        BigInteger numerator = TWO_POW_64;
        BigInteger powLength = BigInteger.valueOf((long)object.getPayloadBytesWithoutNonce().length + extraBytes);
        BigInteger denominator = BigInteger.valueOf(nonceTrialsPerByte).multiply(powLength.add(powLength.multiply(TTL2).divide(TWO_POW_16)));
        return Bytes.expand(numerator.divide(denominator).toByteArray(), 8);
    }

    private byte[] hash(String algorithm, byte[] ... data) {
        MessageDigest mda = this.md(algorithm);
        for (byte[] d : data) {
            mda.update(d);
        }
        return mda.digest();
    }

    private MessageDigest md(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm, this.provider);
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException(e);
        }
    }

    @Override
    public byte[] mac(byte[] key_m, byte[] data) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256", this.provider);
            mac.init(new SecretKeySpec(key_m, "HmacSHA256"));
            return mac.doFinal(data);
        }
        catch (GeneralSecurityException e) {
            throw new ApplicationException(e);
        }
    }

    @Override
    public Pubkey createPubkey(long version, long stream, byte[] privateSigningKey, byte[] privateEncryptionKey, long nonceTrialsPerByte, long extraBytes, Pubkey.Feature ... features) {
        return Factory.createPubkey(version, stream, this.createPublicKey(privateSigningKey), this.createPublicKey(privateEncryptionKey), nonceTrialsPerByte, extraBytes, features);
    }

    @Override
    public BigInteger keyToBigInt(byte[] privateKey) {
        return new BigInteger(1, privateKey);
    }

    @Override
    public long randomNonce() {
        return RANDOM.nextLong();
    }
}

