/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.factory;

import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.NetworkMessage;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.exception.NodeException;
import ch.dissem.bitmessage.factory.BufferPool;
import ch.dissem.bitmessage.factory.V3MessageFactory;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class V3MessageReader {
    private ByteBuffer headerBuffer;
    private ByteBuffer dataBuffer;
    private ReaderState state = ReaderState.MAGIC;
    private String command;
    private int length;
    private byte[] checksum;
    private List<NetworkMessage> messages = new LinkedList<NetworkMessage>();

    public ByteBuffer getActiveBuffer() {
        if (this.state != null && this.state != ReaderState.DATA && this.headerBuffer == null) {
            this.headerBuffer = BufferPool.bufferPool.allocateHeaderBuffer();
        }
        return this.state == ReaderState.DATA ? this.dataBuffer : this.headerBuffer;
    }

    public void update() {
        if (this.state != ReaderState.DATA) {
            this.getActiveBuffer();
            this.headerBuffer.flip();
        }
        switch (this.state) {
            case MAGIC: {
                if (!this.findMagicBytes(this.headerBuffer)) {
                    this.headerBuffer.compact();
                    return;
                }
                this.state = ReaderState.HEADER;
            }
            case HEADER: {
                if (this.headerBuffer.remaining() < 20) {
                    this.headerBuffer.compact();
                    this.headerBuffer.limit(20);
                    return;
                }
                this.command = V3MessageReader.getCommand(this.headerBuffer);
                this.length = (int)Decode.uint32(this.headerBuffer);
                if (this.length > 1600003) {
                    throw new NodeException("Payload of " + this.length + " bytes received, no more than " + 1600003 + " was expected.");
                }
                this.checksum = new byte[4];
                this.headerBuffer.get(this.checksum);
                this.state = ReaderState.DATA;
                BufferPool.bufferPool.deallocate(this.headerBuffer);
                this.headerBuffer = null;
                this.dataBuffer = BufferPool.bufferPool.allocate(this.length);
                this.dataBuffer.clear();
                this.dataBuffer.limit(this.length);
            }
            case DATA: {
                if (this.dataBuffer.position() < this.length) {
                    return;
                }
                this.dataBuffer.flip();
                if (!this.testChecksum(this.dataBuffer)) {
                    this.state = ReaderState.MAGIC;
                    throw new NodeException("Checksum failed for message '" + this.command + "'");
                }
                try {
                    MessagePayload payload = V3MessageFactory.getPayload(this.command, new ByteArrayInputStream(this.dataBuffer.array(), this.dataBuffer.arrayOffset() + this.dataBuffer.position(), this.length), this.length);
                    if (payload == null) break;
                    this.messages.add(new NetworkMessage(payload));
                    break;
                }
                catch (IOException e) {
                    throw new NodeException(e.getMessage());
                }
                finally {
                    this.state = ReaderState.MAGIC;
                    BufferPool.bufferPool.deallocate(this.dataBuffer);
                    this.dataBuffer = null;
                    this.dataBuffer = null;
                }
            }
        }
    }

    public List<NetworkMessage> getMessages() {
        return this.messages;
    }

    private boolean findMagicBytes(ByteBuffer buffer) {
        int i = 0;
        while (buffer.hasRemaining()) {
            if (i == 0) {
                buffer.mark();
            }
            if (buffer.get() == NetworkMessage.MAGIC_BYTES[i]) {
                if (++i != NetworkMessage.MAGIC_BYTES.length) continue;
                return true;
            }
            i = 0;
        }
        if (i > 0) {
            buffer.reset();
        }
        return false;
    }

    private static String getCommand(ByteBuffer buffer) {
        int l;
        int start = buffer.position();
        for (l = 0; l < 12 && buffer.get() != 0; ++l) {
        }
        for (int i = l + 1; i < 12; ++i) {
            if (buffer.get() == 0) continue;
            throw new NodeException("'\\0' padding expected for command");
        }
        try {
            return new String(buffer.array(), start, l, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new ApplicationException(e);
        }
    }

    private boolean testChecksum(ByteBuffer buffer) {
        byte[] payloadChecksum = Singleton.cryptography().sha512(buffer.array(), buffer.arrayOffset() + buffer.position(), this.length);
        for (int i = 0; i < this.checksum.length; ++i) {
            if (this.checksum[i] == payloadChecksum[i]) continue;
            return false;
        }
        return true;
    }

    public void cleanup() {
        this.state = null;
        if (this.headerBuffer != null) {
            BufferPool.bufferPool.deallocate(this.headerBuffer);
        }
        if (this.dataBuffer != null) {
            BufferPool.bufferPool.deallocate(this.dataBuffer);
        }
    }

    private static enum ReaderState {
        MAGIC,
        HEADER,
        DATA;

    }
}

