/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.factory;

import ch.dissem.bitmessage.entity.Addr;
import ch.dissem.bitmessage.entity.CustomMessage;
import ch.dissem.bitmessage.entity.GetData;
import ch.dissem.bitmessage.entity.Inv;
import ch.dissem.bitmessage.entity.MessagePayload;
import ch.dissem.bitmessage.entity.NetworkMessage;
import ch.dissem.bitmessage.entity.ObjectMessage;
import ch.dissem.bitmessage.entity.VerAck;
import ch.dissem.bitmessage.entity.Version;
import ch.dissem.bitmessage.entity.payload.GenericPayload;
import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.entity.valueobject.InventoryVector;
import ch.dissem.bitmessage.entity.valueobject.NetworkAddress;
import ch.dissem.bitmessage.exception.NodeException;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.utils.AccessCounter;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class V3MessageFactory {
    private static Logger LOG = LoggerFactory.getLogger(V3MessageFactory.class);

    V3MessageFactory() {
    }

    public static NetworkMessage read(InputStream in) throws IOException {
        byte[] payloadBytes;
        V3MessageFactory.findMagic(in);
        String command = V3MessageFactory.getCommand(in);
        int length = (int)Decode.uint32(in);
        if (length > 1600003) {
            throw new NodeException("Payload of " + length + " bytes received, no more than 1600003 was expected.");
        }
        byte[] checksum = Decode.bytes(in, 4);
        if (V3MessageFactory.testChecksum(checksum, payloadBytes = Decode.bytes(in, length))) {
            MessagePayload payload = V3MessageFactory.getPayload(command, new ByteArrayInputStream(payloadBytes), length);
            if (payload != null) {
                return new NetworkMessage(payload);
            }
            return null;
        }
        throw new IOException("Checksum failed for message '" + command + "'");
    }

    static MessagePayload getPayload(String command, InputStream stream, int length) throws IOException {
        switch (command) {
            case "version": {
                return V3MessageFactory.parseVersion(stream);
            }
            case "verack": {
                return new VerAck();
            }
            case "addr": {
                return V3MessageFactory.parseAddr(stream);
            }
            case "inv": {
                return V3MessageFactory.parseInv(stream);
            }
            case "getdata": {
                return V3MessageFactory.parseGetData(stream);
            }
            case "object": {
                return V3MessageFactory.readObject(stream, length);
            }
            case "custom": {
                return V3MessageFactory.readCustom(stream, length);
            }
        }
        LOG.debug("Unknown command: " + command);
        return null;
    }

    private static MessagePayload readCustom(InputStream in, int length) throws IOException {
        return CustomMessage.read(in, length);
    }

    public static ObjectMessage readObject(InputStream in, int length) throws IOException {
        ObjectPayload payload;
        AccessCounter counter = new AccessCounter();
        byte[] nonce = Decode.bytes(in, 8, counter);
        long expiresTime = Decode.int64(in, counter);
        long objectType = Decode.uint32(in, counter);
        long version = Decode.varInt(in, counter);
        long stream = Decode.varInt(in, counter);
        byte[] data = Decode.bytes(in, length - counter.length());
        try {
            ByteArrayInputStream dataStream = new ByteArrayInputStream(data);
            payload = Factory.getObjectPayload(objectType, version, stream, dataStream, data.length);
        }
        catch (Exception e) {
            LOG.trace("Could not parse object payload - using generic payload instead", (Throwable)e);
            payload = new GenericPayload(version, stream, data);
        }
        return new ObjectMessage.Builder().nonce(nonce).expiresTime(expiresTime).objectType(objectType).stream(stream).payload(payload).build();
    }

    private static GetData parseGetData(InputStream stream) throws IOException {
        long count = Decode.varInt(stream);
        GetData.Builder builder = new GetData.Builder();
        int i = 0;
        while ((long)i < count) {
            builder.addInventoryVector(V3MessageFactory.parseInventoryVector(stream));
            ++i;
        }
        return builder.build();
    }

    private static Inv parseInv(InputStream stream) throws IOException {
        long count = Decode.varInt(stream);
        Inv.Builder builder = new Inv.Builder();
        int i = 0;
        while ((long)i < count) {
            builder.addInventoryVector(V3MessageFactory.parseInventoryVector(stream));
            ++i;
        }
        return builder.build();
    }

    private static Addr parseAddr(InputStream stream) throws IOException {
        long count = Decode.varInt(stream);
        Addr.Builder builder = new Addr.Builder();
        int i = 0;
        while ((long)i < count) {
            builder.addAddress(V3MessageFactory.parseAddress(stream, false));
            ++i;
        }
        return builder.build();
    }

    private static Version parseVersion(InputStream stream) throws IOException {
        int version = Decode.int32(stream);
        long services = Decode.int64(stream);
        long timestamp = Decode.int64(stream);
        NetworkAddress addrRecv = V3MessageFactory.parseAddress(stream, true);
        NetworkAddress addrFrom = V3MessageFactory.parseAddress(stream, true);
        long nonce = Decode.int64(stream);
        String userAgent = Decode.varString(stream);
        long[] streamNumbers = Decode.varIntList(stream);
        return new Version.Builder().version(version).services(services).timestamp(timestamp).addrRecv(addrRecv).addrFrom(addrFrom).nonce(nonce).userAgent(userAgent).streams(streamNumbers).build();
    }

    private static InventoryVector parseInventoryVector(InputStream stream) throws IOException {
        return new InventoryVector(Decode.bytes(stream, 32));
    }

    private static NetworkAddress parseAddress(InputStream stream, boolean light) throws IOException {
        long streamNumber;
        long time;
        if (!light) {
            time = Decode.int64(stream);
            streamNumber = Decode.uint32(stream);
        } else {
            time = 0L;
            streamNumber = 0L;
        }
        long services = Decode.int64(stream);
        byte[] ipv6 = Decode.bytes(stream, 16);
        int port = Decode.uint16(stream);
        return new NetworkAddress.Builder().time(time).stream(streamNumber).services(services).ipv6(ipv6).port(port).build();
    }

    private static boolean testChecksum(byte[] checksum, byte[] payload) {
        byte[] payloadChecksum = Singleton.cryptography().sha512(new byte[][]{payload});
        for (int i = 0; i < checksum.length; ++i) {
            if (checksum[i] == payloadChecksum[i]) continue;
            return false;
        }
        return true;
    }

    private static String getCommand(InputStream stream) throws IOException {
        byte[] bytes = new byte[12];
        int end = bytes.length;
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)stream.read();
            if (end == bytes.length) {
                if (bytes[i] != 0) continue;
                end = i;
                continue;
            }
            if (bytes[i] == 0) continue;
            throw new IOException("'\\0' padding expected for command");
        }
        return new String(bytes, 0, end, "ASCII");
    }

    private static void findMagic(InputStream in) throws IOException {
        int pos = 0;
        for (int i = 0; i < 1620000; ++i) {
            byte b = (byte)in.read();
            if (b == NetworkMessage.MAGIC_BYTES[pos]) {
                if (pos + 1 == NetworkMessage.MAGIC_BYTES.length) {
                    return;
                }
            } else {
                pos = pos > 0 && b == NetworkMessage.MAGIC_BYTES[0] ? 1 : 0;
            }
            ++pos;
        }
        throw new NodeException("Failed to find MAGIC bytes in stream");
    }
}

