/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.factory;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BufferPool {
    private static final Logger LOG = LoggerFactory.getLogger(BufferPool.class);
    public static final BufferPool bufferPool = new BufferPool();
    private final Map<Integer, Stack<ByteBuffer>> pools = new TreeMap<Integer, Stack<ByteBuffer>>();

    private BufferPool() {
        this.pools.put(24, new Stack());
        this.pools.put(54, new Stack());
        this.pools.put(1000, new Stack());
        this.pools.put(60000, new Stack());
        this.pools.put(1600003, new Stack());
    }

    public synchronized ByteBuffer allocate(int capacity) {
        Integer targetSize = this.getTargetSize(capacity);
        Stack<ByteBuffer> pool = this.pools.get(targetSize);
        if (pool.isEmpty()) {
            LOG.trace("Creating new buffer of size " + targetSize);
            return ByteBuffer.allocate(targetSize);
        }
        return pool.pop();
    }

    public synchronized ByteBuffer allocateHeaderBuffer() {
        Stack<ByteBuffer> pool = this.pools.get(24);
        if (pool.isEmpty()) {
            return ByteBuffer.allocate(24);
        }
        return pool.pop();
    }

    public synchronized void deallocate(ByteBuffer buffer) {
        buffer.clear();
        Stack<ByteBuffer> pool = this.pools.get(buffer.capacity());
        if (pool == null) {
            throw new IllegalArgumentException("Illegal buffer capacity " + buffer.capacity() + " one of " + this.pools.keySet() + " expected.");
        }
        pool.push(buffer);
    }

    private Integer getTargetSize(int capacity) {
        for (Integer size : this.pools.keySet()) {
            if (size < capacity) continue;
            return size;
        }
        throw new IllegalArgumentException("Requested capacity too large: requested=" + capacity + "; max=" + 1600003);
    }
}

