/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.valueobject;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.factory.Factory;
import ch.dissem.bitmessage.utils.Bytes;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class PrivateKey
implements Streamable {
    private static final long serialVersionUID = 8562555470709110558L;
    public static final int PRIVATE_KEY_SIZE = 32;
    private final byte[] privateSigningKey;
    private final byte[] privateEncryptionKey;
    private final Pubkey pubkey;

    public PrivateKey(boolean shorter, long stream, long nonceTrialsPerByte, long extraBytes, Pubkey.Feature ... features) {
        byte[] privEK;
        byte[] pubEK;
        byte[] privSK;
        byte[] pubSK;
        byte[] ripe;
        do {
            privSK = Singleton.cryptography().randomBytes(32);
            privEK = Singleton.cryptography().randomBytes(32);
        } while ((ripe = Pubkey.getRipe(pubSK = Singleton.cryptography().createPublicKey(privSK), pubEK = Singleton.cryptography().createPublicKey(privEK)))[0] != 0 || shorter && ripe[1] != 0);
        this.privateSigningKey = privSK;
        this.privateEncryptionKey = privEK;
        this.pubkey = Singleton.cryptography().createPubkey(4L, stream, this.privateSigningKey, this.privateEncryptionKey, nonceTrialsPerByte, extraBytes, features);
    }

    public PrivateKey(byte[] privateSigningKey, byte[] privateEncryptionKey, Pubkey pubkey) {
        this.privateSigningKey = privateSigningKey;
        this.privateEncryptionKey = privateEncryptionKey;
        this.pubkey = pubkey;
    }

    public PrivateKey(BitmessageAddress address, String passphrase) {
        this(address.getVersion(), address.getStream(), passphrase);
    }

    public PrivateKey(long version, long stream, String passphrase) {
        this(new Builder(version, stream, false).seed(passphrase).generate());
    }

    private PrivateKey(Builder builder) {
        this.privateSigningKey = builder.privSK;
        this.privateEncryptionKey = builder.privEK;
        this.pubkey = Factory.createPubkey(builder.version, builder.stream, builder.pubSK, builder.pubEK, 1000L, 1000L, new Pubkey.Feature[0]);
    }

    public static List<PrivateKey> deterministic(String passphrase, int numberOfAddresses, long version, long stream, boolean shorter) {
        ArrayList<PrivateKey> result = new ArrayList<PrivateKey>(numberOfAddresses);
        Builder builder = new Builder(version, stream, shorter).seed(passphrase);
        for (int i = 0; i < numberOfAddresses; ++i) {
            builder.generate();
            result.add(new PrivateKey(builder));
        }
        return result;
    }

    public static PrivateKey read(InputStream is) throws IOException {
        int version = (int)Decode.varInt(is);
        long stream = Decode.varInt(is);
        int len = (int)Decode.varInt(is);
        Pubkey pubkey = Factory.readPubkey(version, stream, is, len, false);
        len = (int)Decode.varInt(is);
        byte[] signingKey = Decode.bytes(is, len);
        len = (int)Decode.varInt(is);
        byte[] encryptionKey = Decode.bytes(is, len);
        return new PrivateKey(signingKey, encryptionKey, pubkey);
    }

    public byte[] getPrivateSigningKey() {
        return this.privateSigningKey;
    }

    public byte[] getPrivateEncryptionKey() {
        return this.privateEncryptionKey;
    }

    public Pubkey getPubkey() {
        return this.pubkey;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Encode.varInt(this.pubkey.getVersion(), out);
        Encode.varInt(this.pubkey.getStream(), out);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.pubkey.writeUnencrypted(baos);
        Encode.varInt((long)baos.size(), out);
        out.write(baos.toByteArray());
        Encode.varInt((long)this.privateSigningKey.length, out);
        out.write(this.privateSigningKey);
        Encode.varInt((long)this.privateEncryptionKey.length, out);
        out.write(this.privateEncryptionKey);
    }

    @Override
    public void write(ByteBuffer buffer) {
        Encode.varInt(this.pubkey.getVersion(), buffer);
        Encode.varInt(this.pubkey.getStream(), buffer);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.pubkey.writeUnencrypted(baos);
            Encode.varBytes(baos.toByteArray(), buffer);
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
        Encode.varBytes(this.privateSigningKey, buffer);
        Encode.varBytes(this.privateEncryptionKey, buffer);
    }

    private static class Builder {
        final long version;
        final long stream;
        final boolean shorter;
        byte[] seed;
        long nextNonce;
        byte[] privSK;
        byte[] privEK;
        byte[] pubSK;
        byte[] pubEK;

        private Builder(long version, long stream, boolean shorter) {
            this.version = version;
            this.stream = stream;
            this.shorter = shorter;
        }

        Builder seed(String passphrase) {
            try {
                this.seed = passphrase.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ApplicationException(e);
            }
            return this;
        }

        Builder generate() {
            byte[] ripe;
            long signingKeyNonce = this.nextNonce;
            long encryptionKeyNonce = this.nextNonce + 1L;
            do {
                this.privEK = Bytes.truncate(Singleton.cryptography().sha512(this.seed, Encode.varInt(encryptionKeyNonce)), 32);
                this.privSK = Bytes.truncate(Singleton.cryptography().sha512(this.seed, Encode.varInt(signingKeyNonce)), 32);
                this.pubSK = Singleton.cryptography().createPublicKey(this.privSK);
                this.pubEK = Singleton.cryptography().createPublicKey(this.privEK);
                ripe = Singleton.cryptography().ripemd160(new byte[][]{Singleton.cryptography().sha512(this.pubSK, this.pubEK)});
                signingKeyNonce += 2L;
                encryptionKeyNonce += 2L;
            } while (ripe[0] != 0 || this.shorter && ripe[1] != 0);
            this.nextNonce = signingKeyNonce;
            return this;
        }
    }
}

