/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.valueobject;

import ch.dissem.bitmessage.entity.Streamable;
import ch.dissem.bitmessage.exception.ApplicationException;
import ch.dissem.bitmessage.utils.Encode;
import ch.dissem.bitmessage.utils.UnixTime;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class NetworkAddress
implements Streamable {
    private static final long serialVersionUID = 2500120578167100300L;
    private long time;
    private final long stream;
    private final long services;
    private final byte[] ipv6;
    private final int port;

    private NetworkAddress(Builder builder) {
        this.time = builder.time;
        this.stream = builder.stream;
        this.services = builder.services;
        this.ipv6 = builder.ipv6;
        this.port = builder.port;
    }

    public byte[] getIPv6() {
        return this.ipv6;
    }

    public int getPort() {
        return this.port;
    }

    public long getServices() {
        return this.services;
    }

    public long getStream() {
        return this.stream;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByAddress(this.ipv6);
        }
        catch (UnknownHostException e) {
            throw new ApplicationException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAddress that = (NetworkAddress)o;
        return this.port == that.port && Arrays.equals(this.ipv6, that.ipv6);
    }

    public int hashCode() {
        int result = this.ipv6 != null ? Arrays.hashCode(this.ipv6) : 0;
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "[" + this.toInetAddress() + "]:" + this.port;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        this.write(stream, false);
    }

    public void write(OutputStream out, boolean light) throws IOException {
        if (!light) {
            Encode.int64(this.time, out);
            Encode.int32(this.stream, out);
        }
        Encode.int64(this.services, out);
        out.write(this.ipv6);
        Encode.int16((long)this.port, out);
    }

    @Override
    public void write(ByteBuffer buffer) {
        this.write(buffer, false);
    }

    public void write(ByteBuffer buffer, boolean light) {
        if (!light) {
            Encode.int64(this.time, buffer);
            Encode.int32(this.stream, buffer);
        }
        Encode.int64(this.services, buffer);
        buffer.put(this.ipv6);
        Encode.int16((long)this.port, buffer);
    }

    public static final class Builder {
        private long time;
        private long stream;
        private long services = 1L;
        private byte[] ipv6;
        private int port;

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder stream(long stream) {
            this.stream = stream;
            return this;
        }

        public Builder services(long services) {
            this.services = services;
            return this;
        }

        public Builder ip(InetAddress inetAddress) {
            byte[] addr = inetAddress.getAddress();
            if (addr.length == 16) {
                this.ipv6 = addr;
            } else if (addr.length == 4) {
                this.ipv6 = new byte[16];
                this.ipv6[10] = -1;
                this.ipv6[11] = -1;
                System.arraycopy(addr, 0, this.ipv6, 12, 4);
            } else {
                throw new IllegalArgumentException("Weird address " + inetAddress);
            }
            return this;
        }

        public Builder ipv6(byte[] ipv6) {
            this.ipv6 = ipv6;
            return this;
        }

        public Builder ipv6(int p00, int p01, int p02, int p03, int p04, int p05, int p06, int p07, int p08, int p09, int p10, int p11, int p12, int p13, int p14, int p15) {
            this.ipv6 = new byte[]{(byte)p00, (byte)p01, (byte)p02, (byte)p03, (byte)p04, (byte)p05, (byte)p06, (byte)p07, (byte)p08, (byte)p09, (byte)p10, (byte)p11, (byte)p12, (byte)p13, (byte)p14, (byte)p15};
            return this;
        }

        public Builder ipv4(int p00, int p01, int p02, int p03) {
            this.ipv6 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, (byte)p00, (byte)p01, (byte)p02, (byte)p03};
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder address(SocketAddress address) {
            if (!(address instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Unknown type of address: " + address.getClass());
            }
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            this.ip(inetAddress.getAddress());
            this.port(inetAddress.getPort());
            return this;
        }

        public NetworkAddress build() {
            if (this.time == 0L) {
                this.time = UnixTime.now();
            }
            return new NetworkAddress(this);
        }
    }
}

