/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.payload.CryptoBox;
import ch.dissem.bitmessage.entity.payload.V4Broadcast;
import ch.dissem.bitmessage.utils.Decode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class V5Broadcast
extends V4Broadcast {
    private static final long serialVersionUID = 920649721626968644L;
    private byte[] tag;

    private V5Broadcast(long stream, byte[] tag, CryptoBox encrypted) {
        super(5L, stream, encrypted, null);
        this.tag = tag;
    }

    public V5Broadcast(BitmessageAddress senderAddress, Plaintext plaintext) {
        super(5L, senderAddress.getStream(), null, plaintext);
        if (senderAddress.getVersion() < 4L) {
            throw new IllegalArgumentException("Address version 4 (or newer) expected, but was " + senderAddress.getVersion());
        }
        this.tag = senderAddress.getTag();
    }

    public static V5Broadcast read(InputStream is, long stream, int length) throws IOException {
        return new V5Broadcast(stream, Decode.bytes(is, 32), CryptoBox.read(is, length - 32));
    }

    public byte[] getTag() {
        return this.tag;
    }

    @Override
    public void writeBytesToSign(OutputStream out) throws IOException {
        out.write(this.tag);
        super.writeBytesToSign(out);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        out.write(this.tag);
        super.write(out);
    }
}

