/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Encrypted;
import ch.dissem.bitmessage.entity.payload.CryptoBox;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.entity.payload.V3Pubkey;
import ch.dissem.bitmessage.exception.DecryptionFailedException;
import ch.dissem.bitmessage.utils.Decode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class V4Pubkey
extends Pubkey
implements Encrypted {
    private static final long serialVersionUID = 1556710353694033093L;
    private long stream;
    private byte[] tag;
    private CryptoBox encrypted;
    private V3Pubkey decrypted;

    private V4Pubkey(long stream, byte[] tag, CryptoBox encrypted) {
        super(4L);
        this.stream = stream;
        this.tag = tag;
        this.encrypted = encrypted;
    }

    public V4Pubkey(V3Pubkey decrypted) {
        super(4L);
        this.decrypted = decrypted;
        this.stream = decrypted.stream;
        this.tag = BitmessageAddress.calculateTag(4L, decrypted.getStream(), decrypted.getRipe());
    }

    public static V4Pubkey read(InputStream in, long stream, int length, boolean encrypted) throws IOException {
        if (encrypted) {
            return new V4Pubkey(stream, Decode.bytes(in, 32), CryptoBox.read(in, length - 32));
        }
        return new V4Pubkey(V3Pubkey.read(in, stream));
    }

    @Override
    public void encrypt(byte[] publicKey) throws IOException {
        if (this.getSignature() == null) {
            throw new IllegalStateException("Pubkey must be signed before encryption.");
        }
        this.encrypted = new CryptoBox(this.decrypted, publicKey);
    }

    @Override
    public void decrypt(byte[] privateKey) throws IOException, DecryptionFailedException {
        this.decrypted = V3Pubkey.read(this.encrypted.decrypt(privateKey), this.stream);
    }

    @Override
    public boolean isDecrypted() {
        return this.decrypted != null;
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        stream.write(this.tag);
        this.encrypted.write(stream);
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.put(this.tag);
        this.encrypted.write(buffer);
    }

    @Override
    public void writeUnencrypted(OutputStream out) throws IOException {
        this.decrypted.write(out);
    }

    @Override
    public void writeUnencrypted(ByteBuffer buffer) {
        this.decrypted.write(buffer);
    }

    @Override
    public void writeBytesToSign(OutputStream out) throws IOException {
        out.write(this.tag);
        this.decrypted.writeBytesToSign(out);
    }

    @Override
    public long getVersion() {
        return 4L;
    }

    @Override
    public ObjectType getType() {
        return ObjectType.PUBKEY;
    }

    @Override
    public long getStream() {
        return this.stream;
    }

    public byte[] getTag() {
        return this.tag;
    }

    @Override
    public byte[] getSigningKey() {
        return this.decrypted.getSigningKey();
    }

    @Override
    public byte[] getEncryptionKey() {
        return this.decrypted.getEncryptionKey();
    }

    @Override
    public int getBehaviorBitfield() {
        return this.decrypted.getBehaviorBitfield();
    }

    @Override
    public byte[] getSignature() {
        if (this.decrypted != null) {
            return this.decrypted.getSignature();
        }
        return null;
    }

    @Override
    public void setSignature(byte[] signature) {
        this.decrypted.setSignature(signature);
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public long getNonceTrialsPerByte() {
        return this.decrypted.getNonceTrialsPerByte();
    }

    @Override
    public long getExtraBytes() {
        return this.decrypted.getExtraBytes();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V4Pubkey v4Pubkey = (V4Pubkey)o;
        if (this.stream != v4Pubkey.stream) {
            return false;
        }
        if (!Arrays.equals(this.tag, v4Pubkey.tag)) {
            return false;
        }
        return !(this.decrypted == null ? v4Pubkey.decrypted != null : !this.decrypted.equals(v4Pubkey.decrypted));
    }

    public int hashCode() {
        int result = (int)(this.stream ^ this.stream >>> 32);
        result = 31 * result + Arrays.hashCode(this.tag);
        result = 31 * result + (this.decrypted != null ? this.decrypted.hashCode() : 0);
        return result;
    }
}

