/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.BitmessageAddress;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.payload.Broadcast;
import ch.dissem.bitmessage.entity.payload.CryptoBox;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class V4Broadcast
extends Broadcast {
    private static final long serialVersionUID = 195663108282762711L;

    protected V4Broadcast(long version, long stream, CryptoBox encrypted, Plaintext plaintext) {
        super(version, stream, encrypted, plaintext);
    }

    public V4Broadcast(BitmessageAddress senderAddress, Plaintext plaintext) {
        super(4L, senderAddress.getStream(), null, plaintext);
        if (senderAddress.getVersion() >= 4L) {
            throw new IllegalArgumentException("Address version 3 or older expected, but was " + senderAddress.getVersion());
        }
    }

    public static V4Broadcast read(InputStream in, long stream, int length) throws IOException {
        return new V4Broadcast(4L, stream, CryptoBox.read(in, length), null);
    }

    @Override
    public ObjectType getType() {
        return ObjectType.BROADCAST;
    }

    @Override
    public void writeBytesToSign(OutputStream out) throws IOException {
        this.plaintext.write(out, false);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.encrypted.write(out);
    }

    @Override
    public void write(ByteBuffer buffer) {
        this.encrypted.write(buffer);
    }
}

