/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.payload.V2Pubkey;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;

public class V3Pubkey
extends V2Pubkey {
    private static final long serialVersionUID = 6958853116648528319L;
    long nonceTrialsPerByte;
    long extraBytes;
    byte[] signature;

    protected V3Pubkey(long version, Builder builder) {
        super(version);
        this.stream = builder.streamNumber;
        this.behaviorBitfield = builder.behaviorBitfield;
        this.publicSigningKey = this.add0x04(builder.publicSigningKey);
        this.publicEncryptionKey = this.add0x04(builder.publicEncryptionKey);
        this.nonceTrialsPerByte = builder.nonceTrialsPerByte;
        this.extraBytes = builder.extraBytes;
        this.signature = builder.signature;
    }

    public static V3Pubkey read(InputStream is, long stream) throws IOException {
        return new Builder().stream(stream).behaviorBitfield(Decode.int32(is)).publicSigningKey(Decode.bytes(is, 64)).publicEncryptionKey(Decode.bytes(is, 64)).nonceTrialsPerByte(Decode.varInt(is)).extraBytes(Decode.varInt(is)).signature(Decode.varBytes(is)).build();
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.writeBytesToSign(out);
        Encode.varInt((long)this.signature.length, out);
        out.write(this.signature);
    }

    @Override
    public long getVersion() {
        return 3L;
    }

    @Override
    public long getNonceTrialsPerByte() {
        return this.nonceTrialsPerByte;
    }

    @Override
    public long getExtraBytes() {
        return this.extraBytes;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public void writeBytesToSign(OutputStream out) throws IOException {
        super.write(out);
        Encode.varInt(this.nonceTrialsPerByte, out);
        Encode.varInt(this.extraBytes, out);
    }

    @Override
    public byte[] getSignature() {
        return this.signature;
    }

    @Override
    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3Pubkey pubkey = (V3Pubkey)o;
        return Objects.equals(this.nonceTrialsPerByte, pubkey.nonceTrialsPerByte) && Objects.equals(this.extraBytes, pubkey.extraBytes) && this.stream == pubkey.stream && this.behaviorBitfield == pubkey.behaviorBitfield && Arrays.equals(this.publicSigningKey, pubkey.publicSigningKey) && Arrays.equals(this.publicEncryptionKey, pubkey.publicEncryptionKey);
    }

    public int hashCode() {
        return Objects.hash(this.nonceTrialsPerByte, this.extraBytes);
    }

    public static class Builder {
        private long streamNumber;
        private int behaviorBitfield;
        private byte[] publicSigningKey;
        private byte[] publicEncryptionKey;
        private long nonceTrialsPerByte;
        private long extraBytes;
        private byte[] signature = new byte[0];

        public Builder stream(long streamNumber) {
            this.streamNumber = streamNumber;
            return this;
        }

        public Builder behaviorBitfield(int behaviorBitfield) {
            this.behaviorBitfield = behaviorBitfield;
            return this;
        }

        public Builder publicSigningKey(byte[] publicSigningKey) {
            this.publicSigningKey = publicSigningKey;
            return this;
        }

        public Builder publicEncryptionKey(byte[] publicEncryptionKey) {
            this.publicEncryptionKey = publicEncryptionKey;
            return this;
        }

        public Builder nonceTrialsPerByte(long nonceTrialsPerByte) {
            this.nonceTrialsPerByte = nonceTrialsPerByte;
            return this;
        }

        public Builder extraBytes(long extraBytes) {
            this.extraBytes = extraBytes;
            return this;
        }

        public Builder signature(byte[] signature) {
            this.signature = signature;
            return this;
        }

        public V3Pubkey build() {
            return new V3Pubkey(3L, this);
        }
    }
}

