/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.entity.payload.Pubkey;
import ch.dissem.bitmessage.utils.Decode;
import ch.dissem.bitmessage.utils.Encode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class V2Pubkey
extends Pubkey {
    private static final long serialVersionUID = -257598690676510460L;
    protected long stream;
    protected int behaviorBitfield;
    protected byte[] publicSigningKey;
    protected byte[] publicEncryptionKey;

    protected V2Pubkey(long version) {
        super(version);
    }

    private V2Pubkey(long version, Builder builder) {
        super(version);
        this.stream = builder.streamNumber;
        this.behaviorBitfield = builder.behaviorBitfield;
        this.publicSigningKey = this.add0x04(builder.publicSigningKey);
        this.publicEncryptionKey = this.add0x04(builder.publicEncryptionKey);
    }

    public static V2Pubkey read(InputStream is, long stream) throws IOException {
        return new Builder().stream(stream).behaviorBitfield((int)Decode.uint32(is)).publicSigningKey(Decode.bytes(is, 64)).publicEncryptionKey(Decode.bytes(is, 64)).build();
    }

    @Override
    public long getVersion() {
        return 2L;
    }

    @Override
    public ObjectType getType() {
        return ObjectType.PUBKEY;
    }

    @Override
    public long getStream() {
        return this.stream;
    }

    @Override
    public byte[] getSigningKey() {
        return this.publicSigningKey;
    }

    @Override
    public byte[] getEncryptionKey() {
        return this.publicEncryptionKey;
    }

    @Override
    public int getBehaviorBitfield() {
        return this.behaviorBitfield;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        Encode.int32((long)this.behaviorBitfield, out);
        out.write(this.publicSigningKey, 1, 64);
        out.write(this.publicEncryptionKey, 1, 64);
    }

    @Override
    public void write(ByteBuffer buffer) {
        Encode.int32((long)this.behaviorBitfield, buffer);
        buffer.put(this.publicSigningKey, 1, 64);
        buffer.put(this.publicEncryptionKey, 1, 64);
    }

    public static class Builder {
        private long streamNumber;
        private int behaviorBitfield;
        private byte[] publicSigningKey;
        private byte[] publicEncryptionKey;

        public Builder stream(long streamNumber) {
            this.streamNumber = streamNumber;
            return this;
        }

        public Builder behaviorBitfield(int behaviorBitfield) {
            this.behaviorBitfield = behaviorBitfield;
            return this;
        }

        public Builder publicSigningKey(byte[] publicSigningKey) {
            this.publicSigningKey = publicSigningKey;
            return this;
        }

        public Builder publicEncryptionKey(byte[] publicEncryptionKey) {
            this.publicEncryptionKey = publicEncryptionKey;
            return this;
        }

        public V2Pubkey build() {
            return new V2Pubkey(2L, this);
        }
    }
}

