/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.utils.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class Pubkey
extends ObjectPayload {
    private static final long serialVersionUID = -6634533361454999619L;
    public static final long LATEST_VERSION = 4L;

    protected Pubkey(long version) {
        super(version);
    }

    public static byte[] getRipe(byte[] publicSigningKey, byte[] publicEncryptionKey) {
        return Singleton.cryptography().ripemd160(new byte[][]{Singleton.cryptography().sha512(publicSigningKey, publicEncryptionKey)});
    }

    public abstract byte[] getSigningKey();

    public abstract byte[] getEncryptionKey();

    public abstract int getBehaviorBitfield();

    public byte[] getRipe() {
        return Singleton.cryptography().ripemd160(new byte[][]{Singleton.cryptography().sha512(this.getSigningKey(), this.getEncryptionKey())});
    }

    public long getNonceTrialsPerByte() {
        return 0L;
    }

    public long getExtraBytes() {
        return 0L;
    }

    public void writeUnencrypted(OutputStream out) throws IOException {
        this.write(out);
    }

    public void writeUnencrypted(ByteBuffer buffer) {
        this.write(buffer);
    }

    protected byte[] add0x04(byte[] key) {
        if (key.length == 65) {
            return key;
        }
        byte[] result = new byte[65];
        result[0] = 4;
        System.arraycopy(key, 0, result, 1, 64);
        return result;
    }

    public static enum Feature {
        INCLUDE_DESTINATION(30),
        DOES_ACK(31);

        private int bit;

        private Feature(int bitNumber) {
            this.bit = 1 << 31 - bitNumber;
        }

        public static int bitfield(Feature ... features) {
            int bits = 0;
            for (Feature feature : features) {
                bits |= feature.bit;
            }
            return bits;
        }

        public static Feature[] features(int bitfield) {
            ArrayList<Feature> features = new ArrayList<Feature>(Feature.values().length);
            for (Feature feature : Feature.values()) {
                if ((bitfield & feature.bit) == 0) continue;
                features.add(feature);
            }
            return features.toArray(new Feature[features.size()]);
        }

        public boolean isActive(int bitfield) {
            return (bitfield & this.bit) != 0;
        }
    }
}

