/*
 * Decompiled with CFR 0.152.
 */
package ch.dissem.bitmessage.entity.payload;

import ch.dissem.bitmessage.entity.Encrypted;
import ch.dissem.bitmessage.entity.Plaintext;
import ch.dissem.bitmessage.entity.PlaintextHolder;
import ch.dissem.bitmessage.entity.payload.CryptoBox;
import ch.dissem.bitmessage.entity.payload.ObjectPayload;
import ch.dissem.bitmessage.entity.payload.ObjectType;
import ch.dissem.bitmessage.exception.DecryptionFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public class Msg
extends ObjectPayload
implements Encrypted,
PlaintextHolder {
    private static final long serialVersionUID = 4327495048296365733L;
    public static final int ACK_LENGTH = 32;
    private long stream;
    private CryptoBox encrypted;
    private Plaintext plaintext;

    private Msg(long stream, CryptoBox encrypted) {
        super(1L);
        this.stream = stream;
        this.encrypted = encrypted;
    }

    public Msg(Plaintext plaintext) {
        super(1L);
        this.stream = plaintext.getStream();
        this.plaintext = plaintext;
    }

    public static Msg read(InputStream in, long stream, int length) throws IOException {
        return new Msg(stream, CryptoBox.read(in, length));
    }

    @Override
    public Plaintext getPlaintext() {
        return this.plaintext;
    }

    @Override
    public ObjectType getType() {
        return ObjectType.MSG;
    }

    @Override
    public long getStream() {
        return this.stream;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public void writeBytesToSign(OutputStream out) throws IOException {
        this.plaintext.write(out, false);
    }

    @Override
    public byte[] getSignature() {
        return this.plaintext.getSignature();
    }

    @Override
    public void setSignature(byte[] signature) {
        this.plaintext.setSignature(signature);
    }

    @Override
    public void encrypt(byte[] publicKey) throws IOException {
        this.encrypted = new CryptoBox(this.plaintext, publicKey);
    }

    @Override
    public void decrypt(byte[] privateKey) throws IOException, DecryptionFailedException {
        this.plaintext = Plaintext.read(Plaintext.Type.MSG, this.encrypted.decrypt(privateKey));
    }

    @Override
    public boolean isDecrypted() {
        return this.plaintext != null;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        if (this.encrypted == null) {
            throw new IllegalStateException("Msg must be signed and encrypted before writing it.");
        }
        this.encrypted.write(out);
    }

    @Override
    public void write(ByteBuffer buffer) {
        if (this.encrypted == null) {
            throw new IllegalStateException("Msg must be signed and encrypted before writing it.");
        }
        this.encrypted.write(buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Msg msg = (Msg)o;
        return this.stream == msg.stream && (Objects.equals(this.encrypted, msg.encrypted) || Objects.equals(this.plaintext, msg.plaintext));
    }

    public int hashCode() {
        return (int)this.stream;
    }
}

